/*
 * Decompiled with CFR 0.152.
 */
package utils;

import android.content.res.AXmlResourceParser;
import com.dangbei.apk.Version;
import entity.ApkInfo;
import entity.ImpliedFeature;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import utils.FileSizeUtil;
import utils.IconUtil;

public class ApkUtil {
    public static final String VERSION_CODE = "versionCode";
    public static final String VERSION_NAME = "versionName";
    public static final String SDK_VERSION = "sdkVersion";
    public static final String TARGET_SDK_VERSION = "targetSdkVersion";
    public static final String USES_PERMISSION = "uses-permission";
    public static final String APPLICATION_LABEL = "application-label";
    public static final String APPLICATION_ICON = "application-icon";
    public static final String USES_FEATURE = "uses-feature";
    public static final String USES_IMPLIED_FEATURE = "uses-implied-feature";
    public static final String SUPPORTS_SCREENS = "supports-screens";
    public static final String SUPPORTS_ANY_DENSITY = "supports-any-density";
    public static final String DENSITIES = "densities";
    public static final String PACKAGE = "package";
    public static final String APPLICATION = "application:";
    public static final String LAUNCHABLE_ACTIVITY = "launchable-activity";
    public static final String UMEN_APPKEY = "UMEN_APPKEY";
    private ProcessBuilder mBuilder = new ProcessBuilder(new String[0]);
    private ProcessBuilder mBuilder2;
    private static final String SPLIT_REGEX = "(: )|(=')|(' )|'";
    private static final String FEATURE_SPLIT_REGEX = "(:')|(',')|'";
    private String mAaptPath = "lib/aapt";
    private String mImagePath = "D:\\WalleApk";
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.051758E-5f, 1.192093E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNITS = new String[]{"px", "dip", "sp", "pt", "in", "mm", "", ""};
    private static final String[] FRACTION_UNITS = new String[]{"%", "%p", "", "", "", "", "", ""};

    public ApkUtil() {
        this.mBuilder.redirectErrorStream(true);
        this.mBuilder2 = new ProcessBuilder(new String[0]);
        this.mBuilder2.redirectErrorStream(true);
    }

    public ApkInfo getApkInfo(String string) throws Exception {
        Process process = this.mBuilder.command(this.mAaptPath, "d", "badging", string).start();
        InputStream inputStream = null;
        inputStream = process.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf8"));
        String string2 = bufferedReader.readLine();
        try {
            if (string2 == null || !string2.startsWith(PACKAGE)) {
                throw new Exception("\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6b63\u5e38\u89e3\u6790APK\u5305\u3002\u8f93\u51fa\u7ed3\u679c\u4e3a:\n" + string2 + "...");
            }
            ApkInfo apkInfo = new ApkInfo();
            apkInfo.setPath(string);
            apkInfo.setMd5(ApkUtil.getFileMd5(string));
            String string3 = String.valueOf(FileSizeUtil.getFileSize(new File(string))) + "\u5b57\u8282(" + FileSizeUtil.getFileOrFilesSize(string, 3) + "MB)";
            apkInfo.setFilesize(string3);
            FileSizeUtil.createDir(this.mImagePath);
            do {
                this.setApkInfoProperty(apkInfo, string2);
            } while ((string2 = bufferedReader.readLine()) != null);
            this.getChannel(apkInfo, string);
            this.getUMENkey(apkInfo, string);
            String string4 = apkInfo.getApplicationIcons().get("application-icon-240");
            String string5 = String.valueOf(this.mImagePath) + string4.substring(string4.lastIndexOf(".") - 2);
            IconUtil.extractFileFromApk(string, string4, string5);
            apkInfo.setApplicationIcon(string5);
            ApkInfo apkInfo2 = apkInfo;
            return apkInfo2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            process.destroy();
            this.closeIO(inputStream);
            this.closeIO(bufferedReader);
        }
    }

    private ApkInfo getChannel(ApkInfo apkInfo, String string) {
        Process process = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            process = this.mBuilder.command("java", "-jar", "lib/walle-cli-all.jar", "show", string).start();
            inputStream = process.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf8"));
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                throw new Exception("\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6b63\u5e38\u89e3\u6790APK\u5305\u3002\u8f93\u51fa\u7ed3\u679c\u4e3a:\n" + string2 + "...");
            }
            do {
                apkInfo.setChannel(string2.substring(string2.lastIndexOf("=") + 1, string2.length() - 1));
            } while ((string2 = bufferedReader.readLine()) != null);
            ApkInfo apkInfo2 = apkInfo;
            process.destroy();
            this.closeIO(inputStream);
            this.closeIO(bufferedReader);
            return apkInfo2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            process.destroy();
            this.closeIO(inputStream);
            this.closeIO(bufferedReader);
        }
        return apkInfo;
    }

    public void getUMENkey(ApkInfo apkInfo, String string) {
        try {
            int n;
            IconUtil.extractFileFromApk(string, "AndroidManifest.xml", String.valueOf(this.mImagePath) + "//AndroidManifest.xml");
            AXmlResourceParser aXmlResourceParser = new AXmlResourceParser();
            aXmlResourceParser.open(new FileInputStream(String.valueOf(this.mImagePath) + "//AndroidManifest.xml"));
            StringBuilder stringBuilder = new StringBuilder(10);
            String string2 = "\t";
            block7: while ((n = aXmlResourceParser.next()) != 1) {
                switch (n) {
                    case 0: {
                        continue block7;
                    }
                    case 2: {
                        stringBuilder.append("\t");
                        int n2 = aXmlResourceParser.getNamespaceCount(aXmlResourceParser.getDepth() - 1);
                        int n3 = aXmlResourceParser.getNamespaceCount(aXmlResourceParser.getDepth());
                        int n4 = 0;
                        while (n4 != aXmlResourceParser.getAttributeCount()) {
                            if ("UMENG_APPKEY".equals(ApkUtil.getAttributeValue(aXmlResourceParser, n4))) {
                                apkInfo.setUmkey(ApkUtil.getAttributeValue(aXmlResourceParser, n4 + 1));
                            }
                            if ("UMENG_CHANNEL".equals(ApkUtil.getAttributeValue(aXmlResourceParser, n4)) && (apkInfo.getChannel() == null || apkInfo.getChannel().length() < 1 || apkInfo.getChannel().contains("\\") || apkInfo.getChannel().contains("apk") || apkInfo.getChannel().contains(":") || apkInfo.getChannel().contains("Error"))) {
                                apkInfo.setChannel(ApkUtil.getAttributeValue(aXmlResourceParser, n4 + 1));
                            }
                            ++n4;
                        }
                        continue block7;
                    }
                    case 3: {
                        stringBuilder.setLength(stringBuilder.length() - "\t".length());
                        continue block7;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setApkInfoProperty(ApkInfo apkInfo, String string) {
        if (string.startsWith(PACKAGE)) {
            this.splitPackageInfo(apkInfo, string);
        } else if (string.startsWith(LAUNCHABLE_ACTIVITY)) {
            apkInfo.setLaunchableActivity(this.getPropertyInQuote(string));
        } else if (string.startsWith(SDK_VERSION)) {
            apkInfo.setSdkVersion(this.getPropertyInQuote(string));
        } else if (string.startsWith(TARGET_SDK_VERSION)) {
            apkInfo.setTargetSdkVersion(this.getPropertyInQuote(string));
        } else if (string.startsWith(USES_PERMISSION)) {
            apkInfo.addToUsesPermissions(this.getPropertyInQuote(string));
        } else if (string.startsWith(APPLICATION_LABEL)) {
            apkInfo.setApplicationLable(this.getPropertyInQuote(string));
        } else if (string.startsWith(APPLICATION_ICON)) {
            apkInfo.addToApplicationIcons(this.getKeyBeforeColon(string), this.getPropertyInQuote(string));
        } else if (string.startsWith(APPLICATION)) {
            String[] stringArray = string.split("( icon=')|'");
            apkInfo.setApplicationIcon(stringArray[stringArray.length - 1]);
        } else if (string.startsWith(USES_FEATURE)) {
            apkInfo.addToFeatures(this.getPropertyInQuote(string));
        } else if (string.startsWith(USES_IMPLIED_FEATURE)) {
            apkInfo.addToImpliedFeatures(this.getFeature(string));
        }
    }

    private ImpliedFeature getFeature(String string) {
        String[] stringArray = string.split(FEATURE_SPLIT_REGEX);
        ImpliedFeature impliedFeature = new ImpliedFeature(stringArray[1], stringArray[2]);
        return impliedFeature;
    }

    private String getPropertyInQuote(String string) {
        int n = string.indexOf("'") + 1;
        return string.substring(n, string.indexOf(39, n));
    }

    private String getKeyBeforeColon(String string) {
        return string.substring(0, string.indexOf(58));
    }

    private void splitPackageInfo(ApkInfo apkInfo, String string) {
        String[] stringArray = string.split(SPLIT_REGEX);
        apkInfo.setPackageName(stringArray[2]);
        apkInfo.setVersionCode(stringArray[4]);
        apkInfo.setVersionName(stringArray[6]);
    }

    private final void closeIO(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static String getAttributeValue(AXmlResourceParser aXmlResourceParser, int n) {
        int n2 = aXmlResourceParser.getAttributeValueType(n);
        int n3 = aXmlResourceParser.getAttributeValueData(n);
        if (n2 == 3) {
            return aXmlResourceParser.getAttributeValue(n);
        }
        if (n2 == 2) {
            return String.format("?%s%08X", ApkUtil.getPackage(n3), n3);
        }
        if (n2 == 1) {
            return String.format("@%s%08X", ApkUtil.getPackage(n3), n3);
        }
        if (n2 == 4) {
            return String.valueOf(Float.intBitsToFloat(n3));
        }
        if (n2 == 17) {
            return String.format("0x%08X", n3);
        }
        if (n2 == 18) {
            return n3 != 0 ? "true" : "false";
        }
        if (n2 == 5) {
            return String.valueOf(Float.toString(ApkUtil.complexToFloat(n3))) + DIMENSION_UNITS[n3 & 0xF];
        }
        if (n2 == 6) {
            return String.valueOf(Float.toString(ApkUtil.complexToFloat(n3))) + FRACTION_UNITS[n3 & 0xF];
        }
        if (n2 >= 28 && n2 <= 31) {
            return String.format("#%08X", n3);
        }
        if (n2 >= 16 && n2 <= 31) {
            return String.valueOf(n3);
        }
        return String.format("<0x%X, type 0x%02X>", n3, n2);
    }

    private static String getPackage(int n) {
        if (n >>> 24 == 1) {
            return "android:";
        }
        return "";
    }

    public static float complexToFloat(int n) {
        return (float)(n & 0xFFFFFF00) * RADIX_MULTS[n >> 4 & 3];
    }

    public static String getFileMd5(String string) {
        try {
            File file = new File(string);
            MessageDigest messageDigest = MessageDigest.getInstance("md5");
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[10240];
            int n = -1;
            while ((n = fileInputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray3 = byArray2;
            int n2 = byArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                byte by = byArray3[n3];
                int n4 = by & 0xFF;
                String string2 = Integer.toHexString(n4);
                if (string2.length() == 1) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2);
                ++n3;
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "F://db.apk";
            if (stringArray.length > 0) {
                if (stringArray[0].equals("-version") || stringArray[0].equals("-v")) {
                    System.out.println("ApkUtil   -by Geek_Soledad");
                    System.out.println("Version:" + Version.getVersion());
                    return;
                }
                string = stringArray[0];
            }
            ApkInfo apkInfo = new ApkUtil().getApkInfo(string);
            System.out.println(apkInfo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getmAaptPath() {
        return this.mAaptPath;
    }

    public void setmAaptPath(String string) {
        this.mAaptPath = string;
    }
}

