/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;

public class FileSizeUtil {
    public static final int SIZETYPE_B = 1;
    public static final int SIZETYPE_KB = 2;
    public static final int SIZETYPE_MB = 3;
    public static final int SIZETYPE_GB = 4;

    public static double getFileOrFilesSize(String string, int n) {
        File file = new File(string);
        long l = 0L;
        try {
            l = file.isDirectory() ? FileSizeUtil.getFileSizes(file) : FileSizeUtil.getFileSize(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return FileSizeUtil.FormetFileSize(l, n);
    }

    public static String getAutoFileOrFilesSize(String string) {
        File file = new File(string);
        long l = 0L;
        try {
            l = file.isDirectory() ? FileSizeUtil.getFileSizes(file) : FileSizeUtil.getFileSize(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return FileSizeUtil.FormetFileSize(l);
    }

    public static long getFileSize(File file) throws Exception {
        long l = 0L;
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(file);
            l = fileInputStream.available();
        } else {
            file.createNewFile();
        }
        return l;
    }

    private static long getFileSizes(File file) throws Exception {
        long l = 0L;
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            l = fileArray[n].isDirectory() ? (l += FileSizeUtil.getFileSizes(fileArray[n])) : (l += FileSizeUtil.getFileSize(fileArray[n]));
            ++n;
        }
        return l;
    }

    private static String FormetFileSize(long l) {
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        String string = "";
        String string2 = "0B";
        if (l == 0L) {
            return string2;
        }
        string = l < 1024L ? String.valueOf(decimalFormat.format((double)l)) + "B" : (l < 0x100000L ? String.valueOf(decimalFormat.format((double)l / 1024.0)) + "KB" : (l < 0x40000000L ? String.valueOf(decimalFormat.format((double)l / 1048576.0)) + "MB" : String.valueOf(decimalFormat.format((double)l / 1.073741824E9)) + "GB"));
        return string;
    }

    private static double FormetFileSize(long l, int n) {
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        double d = 0.0;
        switch (n) {
            case 1: {
                d = Double.valueOf(decimalFormat.format((double)l));
                break;
            }
            case 2: {
                d = Double.valueOf(decimalFormat.format((double)l / 1024.0));
                break;
            }
            case 3: {
                d = Double.valueOf(decimalFormat.format((double)l / 1048576.0));
                break;
            }
            case 4: {
                d = Double.valueOf(decimalFormat.format((double)l / 1.073741824E9));
                break;
            }
        }
        return d;
    }

    public static boolean createDir(String string) {
        File file = new File(string);
        if (file.exists()) {
            return false;
        }
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        return file.mkdirs();
    }
}

