/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import com.meituan.android.walle.ApkSigningBlock;
import com.meituan.android.walle.ApkSigningPayload;
import com.meituan.android.walle.ChannelReader;
import com.meituan.android.walle.PayloadWriter;
import com.meituan.android.walle.SignatureNotFoundException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public final class ChannelWriter {
    private ChannelWriter() {
    }

    public static void put(File apkFile, String channel) throws IOException, SignatureNotFoundException {
        ChannelWriter.put(apkFile, channel, null);
    }

    public static void put(File apkFile, String channel, Map<String, String> extraInfo) throws IOException, SignatureNotFoundException {
        HashMap<String, String> newData = new HashMap<String, String>();
        Map<String, String> existsData = ChannelReader.getMap(apkFile);
        if (existsData != null) {
            newData.putAll(existsData);
        }
        if (extraInfo != null) {
            extraInfo.remove("channel");
            newData.putAll(extraInfo);
        }
        if (channel != null && channel.length() > 0) {
            newData.put("channel", channel);
        }
        JSONObject jsonObject = new JSONObject(newData);
        ChannelWriter.putRaw(apkFile, jsonObject.toString());
    }

    public static void putRaw(File apkFile, String string) throws IOException, SignatureNotFoundException {
        byte[] bytes = string.getBytes("UTF-8");
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(bytes, 0, bytes.length);
        byteBuffer.flip();
        PayloadWriter.put(apkFile, 0x71777777, byteBuffer);
    }

    public static void remove(File apkFile) throws IOException, SignatureNotFoundException {
        PayloadWriter.handleApkSigningBlock(apkFile, new PayloadWriter.ApkSigningBlockHandler(){

            @Override
            public ApkSigningBlock handle(Map<Integer, ByteBuffer> originIdValues) {
                ApkSigningBlock apkSigningBlock = new ApkSigningBlock();
                Set<Map.Entry<Integer, ByteBuffer>> entrySet = originIdValues.entrySet();
                for (Map.Entry<Integer, ByteBuffer> entry : entrySet) {
                    if (entry.getKey() == 0x71777777) continue;
                    ApkSigningPayload payload = new ApkSigningPayload(entry.getKey(), entry.getValue());
                    apkSigningBlock.addPayload(payload);
                }
                return apkSigningBlock;
            }
        });
    }
}

