/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.conf;

import com.genersoft.iot.vmp.common.ApiSaveConstant;
import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.conf.security.SecurityUtils;
import com.genersoft.iot.vmp.service.ILogService;
import com.genersoft.iot.vmp.storager.dao.dto.LogDto;
import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

@WebFilter(filterName="ApiAccessFilter", urlPatterns={"/api/*"}, asyncSupported=true)
public class ApiAccessFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ApiAccessFilter.class);
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private UserSetup userSetup;
    @Autowired
    private ILogService logService;

    protected void doFilterInternal(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        String username = null;
        username = SecurityUtils.getUserInfo() == null ? servletRequest.getParameter("username") : SecurityUtils.getUserInfo().getUsername();
        long start = System.currentTimeMillis();
        String uriName = ApiSaveConstant.getVal((String)servletRequest.getRequestURI());
        filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        if (uriName != null && this.userSetup.getLogInDatebase().booleanValue()) {
            LogDto logDto = new LogDto();
            logDto.setName(uriName);
            logDto.setUsername(username);
            logDto.setAddress(servletRequest.getRemoteAddr());
            logDto.setResult(HttpStatus.valueOf((int)servletResponse.getStatus()).toString());
            logDto.setTiming(System.currentTimeMillis() - start);
            logDto.setType(servletRequest.getMethod());
            logDto.setUri(servletRequest.getRequestURI());
            logDto.setCreateTime(this.format.format(System.currentTimeMillis()));
            this.logService.add(logDto);
        }
    }

    private String getIP(HttpServletRequest request) {
        if (request == null) {
            return "0.0.0.0";
        }
        String Xip = request.getHeader("X-Real-IP");
        String XFor = request.getHeader("X-Forwarded-For");
        String UNKNOWN_IP = "unknown";
        if (StringUtils.isNotEmpty((CharSequence)XFor) && !UNKNOWN_IP.equalsIgnoreCase(XFor)) {
            int index = XFor.indexOf(",");
            if (index != -1) {
                return XFor.substring(0, index);
            }
            return XFor;
        }
        XFor = Xip;
        if (StringUtils.isNotEmpty((CharSequence)XFor) && !UNKNOWN_IP.equalsIgnoreCase(XFor)) {
            return XFor;
        }
        if (StringUtils.isBlank((CharSequence)XFor) || UNKNOWN_IP.equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)XFor) || UNKNOWN_IP.equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)XFor) || UNKNOWN_IP.equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isBlank((CharSequence)XFor) || UNKNOWN_IP.equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isBlank((CharSequence)XFor) || UNKNOWN_IP.equalsIgnoreCase(XFor)) {
            XFor = request.getRemoteAddr();
        }
        return XFor;
    }
}

