/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.conf;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class DynamicTask {
    @Autowired
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    private Map<String, ScheduledFuture<?>> futureMap = new ConcurrentHashMap();

    @Bean
    public ThreadPoolTaskScheduler threadPoolTaskScheduler() {
        return new ThreadPoolTaskScheduler();
    }

    public String startCron(String key, Runnable task, int cycleForCatalog) {
        this.stopCron(key);
        ScheduledFuture future = this.threadPoolTaskScheduler.scheduleWithFixedDelay(task, (long)cycleForCatalog * 1000L);
        this.futureMap.put(key, future);
        return "startCron";
    }

    public void stopCron(String key) {
        if (this.futureMap.get(key) != null && !((ScheduledFuture)this.futureMap.get(key)).isCancelled()) {
            ((ScheduledFuture)this.futureMap.get(key)).cancel(true);
        }
    }
}

