/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.auth;

import gov.nist.core.InternalErrorHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;
import javax.sip.address.URI;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DigestServerAuthenticationHelper {
    private Logger logger = LoggerFactory.getLogger(DigestServerAuthenticationHelper.class);
    private MessageDigest messageDigest = MessageDigest.getInstance("MD5");
    public static final String DEFAULT_ALGORITHM = "MD5";
    public static final String DEFAULT_SCHEME = "Digest";
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }

    private String generateNonce() {
        Date date = new Date();
        long time = date.getTime();
        Random rand = new Random();
        long pad = rand.nextLong();
        String nonceString = Long.valueOf(time).toString() + Long.valueOf(pad).toString();
        byte[] mdbytes = this.messageDigest.digest(nonceString.getBytes());
        return DigestServerAuthenticationHelper.toHexString((byte[])mdbytes);
    }

    public Response generateChallenge(HeaderFactory headerFactory, Response response, String realm) {
        try {
            WWWAuthenticateHeader proxyAuthenticate = headerFactory.createWWWAuthenticateHeader("Digest");
            proxyAuthenticate.setParameter("realm", realm);
            proxyAuthenticate.setParameter("qop", "auth");
            proxyAuthenticate.setParameter("nonce", this.generateNonce());
            proxyAuthenticate.setParameter("algorithm", "MD5");
            response.setHeader((Header)proxyAuthenticate);
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException((Exception)ex);
        }
        return response;
    }

    public boolean doAuthenticateHashedPassword(Request request, String hashedPassword) {
        AuthorizationHeader authHeader = (AuthorizationHeader)request.getHeader("Authorization");
        if (authHeader == null) {
            return false;
        }
        String realm = authHeader.getRealm();
        String username = authHeader.getUsername();
        if (username == null || realm == null) {
            return false;
        }
        String nonce = authHeader.getNonce();
        URI uri = authHeader.getURI();
        if (uri == null) {
            return false;
        }
        String A2 = request.getMethod().toUpperCase() + ":" + uri.toString();
        String HA1 = hashedPassword;
        byte[] mdbytes = this.messageDigest.digest(A2.getBytes());
        String HA2 = DigestServerAuthenticationHelper.toHexString((byte[])mdbytes);
        String cnonce = authHeader.getCNonce();
        String KD = HA1 + ":" + nonce;
        if (cnonce != null) {
            KD = KD + ":" + cnonce;
        }
        KD = KD + ":" + HA2;
        mdbytes = this.messageDigest.digest(KD.getBytes());
        String mdString = DigestServerAuthenticationHelper.toHexString((byte[])mdbytes);
        String response = authHeader.getResponse();
        return mdString.equals(response);
    }

    public boolean doAuthenticatePlainTextPassword(Request request, String pass) {
        AuthorizationHeader authHeader = (AuthorizationHeader)request.getHeader("Authorization");
        if (authHeader == null) {
            return false;
        }
        String realm = authHeader.getRealm().trim();
        String username = authHeader.getUsername().trim();
        if (username == null || realm == null) {
            return false;
        }
        String nonce = authHeader.getNonce();
        URI uri = authHeader.getURI();
        if (uri == null) {
            return false;
        }
        String qop = authHeader.getQop();
        String cnonce = authHeader.getCNonce();
        int nc = authHeader.getNonceCount();
        String ncStr = String.format("%08x", nc).toUpperCase();
        String A1 = username + ":" + realm + ":" + pass;
        String A2 = request.getMethod().toUpperCase() + ":" + uri.toString();
        byte[] mdbytes = this.messageDigest.digest(A1.getBytes());
        String HA1 = DigestServerAuthenticationHelper.toHexString((byte[])mdbytes);
        this.logger.debug("A1: " + A1);
        this.logger.debug("A2: " + A2);
        mdbytes = this.messageDigest.digest(A2.getBytes());
        String HA2 = DigestServerAuthenticationHelper.toHexString((byte[])mdbytes);
        this.logger.debug("HA1: " + HA1);
        this.logger.debug("HA2: " + HA2);
        this.logger.debug("nonce: " + nonce);
        this.logger.debug("nc: " + ncStr);
        this.logger.debug("cnonce: " + cnonce);
        this.logger.debug("qop: " + qop);
        String KD = HA1 + ":" + nonce;
        if (qop != null && qop.equals("auth")) {
            if (nc != -1) {
                KD = KD + ":" + ncStr;
            }
            if (cnonce != null) {
                KD = KD + ":" + cnonce;
            }
            KD = KD + ":" + qop;
        }
        KD = KD + ":" + HA2;
        this.logger.debug("KD: " + KD);
        mdbytes = this.messageDigest.digest(KD.getBytes());
        String mdString = DigestServerAuthenticationHelper.toHexString((byte[])mdbytes);
        this.logger.debug("mdString: " + mdString);
        String response = authHeader.getResponse();
        this.logger.debug("response: " + response);
        return mdString.equals(response);
    }
}

