/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.event.platformNotRegister;

import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.bean.SendRtpItem;
import com.genersoft.iot.vmp.gb28181.event.SipSubscribe;
import com.genersoft.iot.vmp.gb28181.event.platformNotRegister.PlatformNotRegisterEvent;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommanderFroPlatform;
import com.genersoft.iot.vmp.media.zlm.ZLMRTPServerFactory;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PlatformNotRegisterEventLister
implements ApplicationListener<PlatformNotRegisterEvent> {
    private static final Logger logger = LoggerFactory.getLogger(PlatformNotRegisterEventLister.class);
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private IMediaServerService mediaServerService;
    @Autowired
    private SIPCommanderFroPlatform sipCommanderFroPlatform;
    @Autowired
    private ZLMRTPServerFactory zlmrtpServerFactory;
    @Autowired
    private SipConfig config;

    public void onApplicationEvent(PlatformNotRegisterEvent event) {
        logger.info("\u5e73\u53f0\u672a\u6ce8\u518c\u4e8b\u4ef6\u89e6\u53d1\uff0c\u5e73\u53f0\u56fd\u6807ID\uff1a" + event.getPlatformGbID());
        ParentPlatform parentPlatform = this.storager.queryParentPlatByServerGBId(event.getPlatformGbID());
        if (parentPlatform == null) {
            logger.info("\u5e73\u53f0\u672a\u6ce8\u518c\u4e8b\u4ef6\u89e6\u53d1\uff0c\u4f46\u5e73\u53f0\u5df2\u7ecf\u5220\u9664!!! \u5e73\u53f0\u56fd\u6807ID\uff1a" + event.getPlatformGbID());
            return;
        }
        List sendRtpItems = this.redisCatchStorage.querySendRTPServer(event.getPlatformGbID());
        logger.info("\u505c\u6b62[ {} ]\u7684\u6240\u6709\u63a8\u6d41size", (Object)sendRtpItems.size());
        if (sendRtpItems != null && sendRtpItems.size() > 0) {
            logger.info("\u505c\u6b62[ {} ]\u7684\u6240\u6709\u63a8\u6d41", (Object)event.getPlatformGbID());
            StringBuilder app = new StringBuilder();
            StringBuilder stream = new StringBuilder();
            for (SendRtpItem sendRtpItem : sendRtpItems) {
                if (app.length() != 0) {
                    app.append(",");
                }
                app.append(sendRtpItem.getApp());
                if (stream.length() != 0) {
                    stream.append(",");
                }
                stream.append(sendRtpItem.getStreamId());
                this.redisCatchStorage.deleteSendRTPServer(event.getPlatformGbID(), sendRtpItem.getChannelId());
                MediaServerItem mediaInfo = this.mediaServerService.getOne(sendRtpItem.getMediaServerId());
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("vhost", "__defaultVhost__");
                param.put("app", app.toString());
                param.put("stream", stream.toString());
                this.zlmrtpServerFactory.stopSendRtpStream(mediaInfo, param);
            }
        }
        Timer timer = new Timer();
        SipSubscribe.Event okEvent = responseEvent -> timer.cancel();
        logger.info("\u5411\u5e73\u53f0\u6ce8\u518c\uff0c\u5e73\u53f0\u56fd\u6807ID\uff1a" + event.getPlatformGbID());
        this.sipCommanderFroPlatform.register(parentPlatform, null, okEvent);
        timer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, this.config.getRegisterTimeInterval() * 1000, (long)(this.config.getRegisterTimeInterval() * 1000));
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ SIPCommanderFroPlatform access$100(PlatformNotRegisterEventLister x0) {
        return x0.sipCommanderFroPlatform;
    }
}

