/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.session;

import com.genersoft.iot.vmp.gb28181.bean.SsrcTransaction;
import com.genersoft.iot.vmp.utils.SerializeUtils;
import com.genersoft.iot.vmp.utils.redis.RedisUtil;
import gov.nist.javax.sip.stack.SIPDialog;
import java.util.ArrayList;
import java.util.List;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VideoStreamSessionManager {
    @Autowired
    private RedisUtil redisUtil;

    public void put(String deviceId, String channelId, String ssrc, String streamId, String mediaServerId, ClientTransaction transaction) {
        SsrcTransaction ssrcTransaction = new SsrcTransaction();
        ssrcTransaction.setDeviceId(deviceId);
        ssrcTransaction.setChannelId(channelId);
        ssrcTransaction.setStreamId(streamId);
        byte[] transactionByteArray = SerializeUtils.serialize((Object)transaction);
        ssrcTransaction.setTransaction(transactionByteArray);
        ssrcTransaction.setSsrc(ssrc);
        ssrcTransaction.setMediaServerId(mediaServerId);
        this.redisUtil.set("VMP_media_transaction_" + deviceId + "_" + channelId, (Object)ssrcTransaction);
    }

    public void put(String deviceId, String channelId, Dialog dialog) {
        SsrcTransaction ssrcTransaction = this.getSsrcTransaction(deviceId, channelId);
        if (ssrcTransaction != null) {
            byte[] dialogByteArray = SerializeUtils.serialize((Object)dialog);
            ssrcTransaction.setDialog(dialogByteArray);
        }
        this.redisUtil.set("VMP_media_transaction_" + deviceId + "_" + channelId, (Object)ssrcTransaction);
    }

    public ClientTransaction getTransaction(String deviceId, String channelId) {
        SsrcTransaction ssrcTransaction = this.getSsrcTransaction(deviceId, channelId);
        if (ssrcTransaction == null) {
            return null;
        }
        byte[] transactionByteArray = ssrcTransaction.getTransaction();
        ClientTransaction clientTransaction = (ClientTransaction)SerializeUtils.deSerialize((byte[])transactionByteArray);
        return clientTransaction;
    }

    public SIPDialog getDialog(String deviceId, String channelId) {
        SsrcTransaction ssrcTransaction = this.getSsrcTransaction(deviceId, channelId);
        if (ssrcTransaction == null) {
            return null;
        }
        byte[] dialogByteArray = ssrcTransaction.getDialog();
        if (dialogByteArray == null) {
            return null;
        }
        SIPDialog dialog = (SIPDialog)SerializeUtils.deSerialize((byte[])dialogByteArray);
        return dialog;
    }

    public SsrcTransaction getSsrcTransaction(String deviceId, String channelId) {
        SsrcTransaction ssrcTransaction = (SsrcTransaction)this.redisUtil.get("VMP_media_transaction_" + deviceId + "_" + channelId);
        return ssrcTransaction;
    }

    public String getStreamId(String deviceId, String channelId) {
        SsrcTransaction ssrcTransaction = this.getSsrcTransaction(deviceId, channelId);
        if (ssrcTransaction == null) {
            return null;
        }
        return ssrcTransaction.getStreamId();
    }

    public String getMediaServerId(String deviceId, String channelId) {
        SsrcTransaction ssrcTransaction = this.getSsrcTransaction(deviceId, channelId);
        if (ssrcTransaction == null) {
            return null;
        }
        return ssrcTransaction.getMediaServerId();
    }

    public String getSSRC(String deviceId, String channelId) {
        SsrcTransaction ssrcTransaction = this.getSsrcTransaction(deviceId, channelId);
        if (ssrcTransaction == null) {
            return null;
        }
        return ssrcTransaction.getSsrc();
    }

    public void remove(String deviceId, String channelId) {
        SsrcTransaction ssrcTransaction = this.getSsrcTransaction(deviceId, channelId);
        if (ssrcTransaction == null) {
            return;
        }
        this.redisUtil.del(new String[]{"VMP_media_transaction_" + deviceId + "_" + channelId});
    }

    public List<SsrcTransaction> getAllSsrc() {
        List ssrcTransactionKeys = this.redisUtil.scan(String.format("%s_*_*", "VMP_media_transaction_"));
        ArrayList<SsrcTransaction> result = new ArrayList<SsrcTransaction>();
        for (int i = 0; i < ssrcTransactionKeys.size(); ++i) {
            String key = (String)ssrcTransactionKeys.get(i);
            SsrcTransaction ssrcTransaction = (SsrcTransaction)this.redisUtil.get(key);
            result.add(ssrcTransaction);
        }
        return result;
    }
}

