/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request;

import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class SIPRequestProcessorParent {
    private static final Logger logger = LoggerFactory.getLogger(SIPRequestProcessorParent.class);
    @Autowired
    @Qualifier(value="tcpSipProvider")
    private SipProviderImpl tcpSipProvider;
    @Autowired
    @Qualifier(value="udpSipProvider")
    private SipProviderImpl udpSipProvider;

    public ServerTransaction getServerTransaction(RequestEvent evt) {
        Request request = evt.getRequest();
        ServerTransaction serverTransaction = evt.getServerTransaction();
        boolean isTcp = false;
        ViaHeader reqViaHeader = (ViaHeader)request.getHeader("Via");
        String transport = reqViaHeader.getTransport();
        if (transport.equals("TCP")) {
            isTcp = true;
        }
        if (serverTransaction == null) {
            try {
                if (isTcp) {
                    SipStackImpl stack = (SipStackImpl)this.tcpSipProvider.getSipStack();
                    serverTransaction = (SIPServerTransaction)stack.findTransaction((SIPMessage)((SIPRequest)request), true);
                    if (serverTransaction == null) {
                        serverTransaction = this.tcpSipProvider.getNewServerTransaction(request);
                    }
                } else {
                    SipStackImpl stack = (SipStackImpl)this.udpSipProvider.getSipStack();
                    serverTransaction = (SIPServerTransaction)stack.findTransaction((SIPMessage)((SIPRequest)request), true);
                    if (serverTransaction == null) {
                        serverTransaction = this.udpSipProvider.getNewServerTransaction(request);
                    }
                }
            }
            catch (TransactionAlreadyExistsException e) {
                logger.error(e.getMessage());
            }
            catch (TransactionUnavailableException e) {
                logger.error(e.getMessage());
            }
        }
        return serverTransaction;
    }

    public AddressFactory getAddressFactory() {
        try {
            return SipFactory.getInstance().createAddressFactory();
        }
        catch (PeerUnavailableException e) {
            e.printStackTrace();
            return null;
        }
    }

    public HeaderFactory getHeaderFactory() {
        try {
            return SipFactory.getInstance().createHeaderFactory();
        }
        catch (PeerUnavailableException e) {
            e.printStackTrace();
            return null;
        }
    }

    public MessageFactory getMessageFactory() {
        try {
            return SipFactory.getInstance().createMessageFactory();
        }
        catch (PeerUnavailableException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void responseAck(RequestEvent evt, int statusCode) throws SipException, InvalidArgumentException, ParseException {
        Response response = this.getMessageFactory().createResponse(statusCode, evt.getRequest());
        ServerTransaction serverTransaction = this.getServerTransaction(evt);
        serverTransaction.sendResponse(response);
        if (statusCode >= 200 && !"NOTIFY".equals(evt.getRequest().getMethod()) && serverTransaction.getDialog() != null) {
            serverTransaction.getDialog().delete();
        }
    }

    public void responseAck(RequestEvent evt, int statusCode, String msg) throws SipException, InvalidArgumentException, ParseException {
        Response response = this.getMessageFactory().createResponse(statusCode, evt.getRequest());
        response.setReasonPhrase(msg);
        ServerTransaction serverTransaction = this.getServerTransaction(evt);
        serverTransaction.sendResponse(response);
        if (statusCode >= 200 && !"NOTIFY".equals(evt.getRequest().getMethod()) && serverTransaction.getDialog() != null) {
            serverTransaction.getDialog().delete();
        }
    }

    public void responseAck(RequestEvent evt, String sdp) throws SipException, InvalidArgumentException, ParseException {
        Response response = this.getMessageFactory().createResponse(200, evt.getRequest());
        SipFactory sipFactory = SipFactory.getInstance();
        ContentTypeHeader contentTypeHeader = sipFactory.createHeaderFactory().createContentTypeHeader("APPLICATION", "SDP");
        response.setContent((Object)sdp, contentTypeHeader);
        SipURI sipURI = (SipURI)evt.getRequest().getRequestURI();
        Address concatAddress = sipFactory.createAddressFactory().createAddress((URI)sipFactory.createAddressFactory().createSipURI(sipURI.getUser(), sipURI.getHost() + ":" + sipURI.getPort()));
        response.addHeader((Header)sipFactory.createHeaderFactory().createContactHeader(concatAddress));
        this.getServerTransaction(evt).sendResponse(response);
    }

    public Element getRootElement(RequestEvent evt) throws DocumentException {
        return this.getRootElement(evt, "gb2312");
    }

    public Element getRootElement(RequestEvent evt, String charset) throws DocumentException {
        if (charset == null) {
            charset = "gb2312";
        }
        Request request = evt.getRequest();
        SAXReader reader = new SAXReader();
        reader.setEncoding(charset);
        Document xml = reader.read((InputStream)new ByteArrayInputStream(request.getRawContent()));
        return xml.getRootElement();
    }
}

