/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.notify.cmd;

import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.gb28181.bean.GbStream;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommanderFroPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.notify.NotifyMessageHandler;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.vmanager.gb28181.platform.bean.ChannelReduce;
import java.text.ParseException;
import java.util.List;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import javax.sip.header.FromHeader;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CatalogNotifyMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(CatalogNotifyMessageHandler.class);
    private final String cmdType = "Catalog";
    @Autowired
    private NotifyMessageHandler notifyMessageHandler;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private SIPCommanderFroPlatform cmderFroPlatform;
    @Autowired
    private SipConfig config;

    public void afterPropertiesSet() throws Exception {
        this.notifyMessageHandler.addHandler("Catalog", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element element) {
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element rootElement) {
        String key = "CALLBACK_CATALOG" + parentPlatform.getServerGBId();
        FromHeader fromHeader = (FromHeader)evt.getRequest().getHeader("From");
        try {
            DeviceChannel deviceChannel;
            this.responseAck(evt, 200);
            Element snElement = rootElement.element("SN");
            String sn = snElement.getText();
            List channelReduces = this.storager.queryChannelListInParentPlatform(parentPlatform.getServerGBId());
            List gbStreams = this.storager.queryGbStreamListInPlatform(parentPlatform.getServerGBId());
            int size = channelReduces.size() + gbStreams.size();
            if (channelReduces.size() > 0) {
                for (ChannelReduce channelReduce : channelReduces) {
                    deviceChannel = this.storager.queryChannel(channelReduce.getDeviceId(), channelReduce.getChannelId());
                    this.cmderFroPlatform.catalogQuery(deviceChannel, parentPlatform, sn, fromHeader.getTag(), size);
                }
            }
            if (gbStreams.size() > 0) {
                for (GbStream gbStream : gbStreams) {
                    deviceChannel = new DeviceChannel();
                    deviceChannel.setChannelId(gbStream.getGbId());
                    deviceChannel.setName(gbStream.getName());
                    deviceChannel.setLongitude(gbStream.getLongitude());
                    deviceChannel.setLatitude(gbStream.getLatitude());
                    deviceChannel.setDeviceId(parentPlatform.getDeviceGBId());
                    deviceChannel.setManufacture("wvp-pro");
                    deviceChannel.setStatus(gbStream.isStatus() ? 1 : 0);
                    deviceChannel.setRegisterWay(1);
                    deviceChannel.setCivilCode(this.config.getDomain());
                    deviceChannel.setModel("live");
                    deviceChannel.setOwner("wvp-pro");
                    deviceChannel.setParental(0);
                    deviceChannel.setSecrecy("0");
                    deviceChannel.setSecrecy("0");
                    this.cmderFroPlatform.catalogQuery(deviceChannel, parentPlatform, sn, fromHeader.getTag(), size);
                }
            }
            if (size == 0) {
                this.cmderFroPlatform.catalogQuery(null, parentPlatform, sn, fromHeader.getTag(), size);
            }
        }
        catch (SipException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

