/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.cmd;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.ResponseMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import javax.sip.RequestEvent;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeviceConfigResponseMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(DeviceConfigResponseMessageHandler.class);
    private final String cmdType = "DeviceConfig";
    @Autowired
    private ResponseMessageHandler responseMessageHandler;
    @Autowired
    private DeferredResultHolder deferredResultHolder;

    public void afterPropertiesSet() throws Exception {
        this.responseMessageHandler.addHandler("DeviceConfig", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element element) {
        JSONObject json = new JSONObject();
        XmlUtil.node2Json((Element)element, (JSONObject)json);
        String channelId = XmlUtil.getText((Element)element, (String)"DeviceID");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(json.toJSONString());
        }
        String key = "CALLBACK_DEVICECONFIG" + device.getDeviceId() + channelId;
        RequestMessage msg = new RequestMessage();
        msg.setKey(key);
        msg.setData((Object)json);
        this.deferredResultHolder.invokeAllResult(msg);
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element rootElement) {
    }
}

