/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.cmd;

import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.gb28181.bean.BaiduPoint;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.MobilePosition;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.ResponseMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.NumericUtil;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.utils.GpsUtil;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MobilePositionResponseMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(MobilePositionResponseMessageHandler.class);
    private final String cmdType = "MobilePosition";
    @Autowired
    private ResponseMessageHandler responseMessageHandler;
    @Autowired
    private UserSetup userSetup;
    @Autowired
    private IVideoManagerStorager storager;

    public void afterPropertiesSet() throws Exception {
        this.responseMessageHandler.addHandler("MobilePosition", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element rootElement) {
        try {
            rootElement = this.getRootElement(evt, device.getCharset());
            MobilePosition mobilePosition = new MobilePosition();
            if (!StringUtils.isEmpty((Object)device.getName())) {
                mobilePosition.setDeviceName(device.getName());
            }
            mobilePosition.setDeviceId(device.getDeviceId());
            mobilePosition.setChannelId(XmlUtil.getText((Element)rootElement, (String)"DeviceID"));
            mobilePosition.setTime(XmlUtil.getText((Element)rootElement, (String)"Time"));
            mobilePosition.setLongitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Longitude")));
            mobilePosition.setLatitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Latitude")));
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Speed"))) {
                mobilePosition.setSpeed(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Speed")));
            } else {
                mobilePosition.setSpeed(0.0);
            }
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Direction"))) {
                mobilePosition.setDirection(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Direction")));
            } else {
                mobilePosition.setDirection(0.0);
            }
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Altitude"))) {
                mobilePosition.setAltitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Altitude")));
            } else {
                mobilePosition.setAltitude(0.0);
            }
            mobilePosition.setReportSource("Mobile Position");
            BaiduPoint bp = new BaiduPoint();
            bp = GpsUtil.Wgs84ToBd09((String)String.valueOf(mobilePosition.getLongitude()), (String)String.valueOf(mobilePosition.getLatitude()));
            this.logger.info("\u767e\u5ea6\u5750\u6807\uff1a" + bp.getBdLng() + ", " + bp.getBdLat());
            mobilePosition.setGeodeticSystem("BD-09");
            mobilePosition.setCnLng(bp.getBdLng());
            mobilePosition.setCnLat(bp.getBdLat());
            if (!this.userSetup.getSavePositionHistory().booleanValue()) {
                this.storager.clearMobilePositionsByDeviceId(device.getDeviceId());
            }
            this.storager.insertMobilePosition(mobilePosition);
            this.responseAck(evt, 200);
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element element) {
    }
}

