/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.cmd;

import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.bean.RecordInfo;
import com.genersoft.iot.vmp.gb28181.bean.RecordItem;
import com.genersoft.iot.vmp.gb28181.transmit.callback.CheckForAllRecordsThread;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.ResponseMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.DateUtil;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import com.genersoft.iot.vmp.utils.redis.RedisUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordInfoResponseMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(RecordInfoResponseMessageHandler.class);
    public static volatile List<String> threadNameList = new ArrayList();
    private final String cmdType = "RecordInfo";
    private static final String CACHE_RECORDINFO_KEY = "CACHE_RECORDINFO_";
    @Autowired
    private ResponseMessageHandler responseMessageHandler;
    @Autowired
    private RedisUtil redis;
    @Autowired
    private DeferredResultHolder deferredResultHolder;

    public void afterPropertiesSet() throws Exception {
        this.responseMessageHandler.addHandler("RecordInfo", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element rootElement) {
        try {
            this.responseAck(evt, 200);
            rootElement = this.getRootElement(evt, device.getCharset());
            String uuid = UUID.randomUUID().toString().replace("-", "");
            RecordInfo recordInfo = new RecordInfo();
            Element deviceIdElement = rootElement.element("DeviceID");
            String channelId = deviceIdElement.getText();
            String key = "CALLBACK_RECORDINFO" + device.getDeviceId() + channelId;
            recordInfo.setDeviceId(device.getDeviceId());
            recordInfo.setChannelId(channelId);
            recordInfo.setName(XmlUtil.getText((Element)rootElement, (String)"Name"));
            if (XmlUtil.getText((Element)rootElement, (String)"SumNum") == null || XmlUtil.getText((Element)rootElement, (String)"SumNum") == "") {
                recordInfo.setSumNum(0);
            } else {
                recordInfo.setSumNum(Integer.parseInt(XmlUtil.getText((Element)rootElement, (String)"SumNum")));
            }
            String sn = XmlUtil.getText((Element)rootElement, (String)"SN");
            Element recordListElement = rootElement.element("RecordList");
            if (recordListElement == null || recordInfo.getSumNum() == 0) {
                this.logger.info("\u65e0\u5f55\u50cf\u6570\u636e");
                RequestMessage msg = new RequestMessage();
                msg.setKey(key);
                msg.setData((Object)recordInfo);
                this.deferredResultHolder.invokeAllResult(msg);
            } else {
                Iterator recordListIterator = recordListElement.elementIterator();
                ArrayList<RecordItem> recordList = new ArrayList<RecordItem>();
                if (recordListIterator != null) {
                    RecordItem record = new RecordItem();
                    this.logger.info("\u5904\u7406\u5f55\u50cf\u5217\u8868\u6570\u636e...");
                    while (recordListIterator.hasNext()) {
                        Element itemRecord = (Element)recordListIterator.next();
                        Element recordElement = itemRecord.element("DeviceID");
                        if (recordElement == null) {
                            this.logger.info("\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u4e0b\u4e00\u4e2a...");
                            continue;
                        }
                        record = new RecordItem();
                        record.setDeviceId(XmlUtil.getText((Element)itemRecord, (String)"DeviceID"));
                        record.setName(XmlUtil.getText((Element)itemRecord, (String)"Name"));
                        record.setFilePath(XmlUtil.getText((Element)itemRecord, (String)"FilePath"));
                        record.setAddress(XmlUtil.getText((Element)itemRecord, (String)"Address"));
                        record.setStartTime(DateUtil.ISO8601Toyyyy_MM_dd_HH_mm_ss((String)XmlUtil.getText((Element)itemRecord, (String)"StartTime")));
                        record.setEndTime(DateUtil.ISO8601Toyyyy_MM_dd_HH_mm_ss((String)XmlUtil.getText((Element)itemRecord, (String)"EndTime")));
                        record.setSecrecy(itemRecord.element("Secrecy") == null ? 0 : Integer.parseInt(XmlUtil.getText((Element)itemRecord, (String)"Secrecy")));
                        record.setType(XmlUtil.getText((Element)itemRecord, (String)"Type"));
                        record.setRecorderId(XmlUtil.getText((Element)itemRecord, (String)"RecorderID"));
                        recordList.add(record);
                    }
                    recordInfo.setRecordList(recordList);
                }
                String cacheKey = CACHE_RECORDINFO_KEY + device.getDeviceId() + sn;
                this.redis.set(cacheKey + "_" + uuid, recordList, 90L);
                if (!threadNameList.contains(cacheKey)) {
                    threadNameList.add(cacheKey);
                    CheckForAllRecordsThread chk = new CheckForAllRecordsThread(cacheKey, recordInfo);
                    chk.setName(cacheKey);
                    chk.setDeferredResultHolder(this.deferredResultHolder);
                    chk.setRedis(this.redis);
                    chk.setLogger(this.logger);
                    chk.start();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Start Thread " + cacheKey + ".");
                    }
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Thread " + cacheKey + " already started.");
                }
            }
        }
        catch (SipException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element element) {
    }
}

