/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.media.zlm;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.conf.MediaConfig;
import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.media.zlm.ZLMHttpHookSubscribe;
import com.genersoft.iot.vmp.media.zlm.ZLMMediaListManager;
import com.genersoft.iot.vmp.media.zlm.ZLMRESTfulUtils;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.IPlayService;
import com.genersoft.iot.vmp.service.bean.SSRCInfo;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/index/hook"})
public class ZLMHttpHookListener {
    private static final Logger logger = LoggerFactory.getLogger(ZLMHttpHookListener.class);
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private IPlayService playService;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private IMediaServerService mediaServerService;
    @Autowired
    private ZLMRESTfulUtils zlmresTfulUtils;
    @Autowired
    private ZLMMediaListManager zlmMediaListManager;
    @Autowired
    private ZLMHttpHookSubscribe subscribe;
    @Autowired
    private UserSetup userSetup;
    @Autowired
    private MediaConfig mediaConfig;

    @ResponseBody
    @PostMapping(value={"/on_flow_report"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onFlowReport(@RequestBody JSONObject json) {
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_flow_report API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        }
        String mediaServerId = json.getString("mediaServerId");
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("msg", (Object)"success");
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_http_access"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onHttpAccess(@RequestBody JSONObject json) {
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_http_access API \u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        }
        String mediaServerId = json.getString("mediaServerId");
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("err", (Object)"");
        ret.put("path", (Object)"");
        ret.put("second", (Object)600);
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_play"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onPlay(@RequestBody JSONObject json) {
        MediaServerItem mediaInfo;
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_play API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        }
        String mediaServerId = json.getString("mediaServerId");
        ZLMHttpHookSubscribe.Event subscribe = this.subscribe.getSubscribe(ZLMHttpHookSubscribe.HookType.on_play, json);
        if (subscribe != null && (mediaInfo = this.mediaServerService.getOne(mediaServerId)) != null) {
            subscribe.response(mediaInfo, json);
        }
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("msg", (Object)"success");
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_publish"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onPublish(@RequestBody JSONObject json) {
        MediaServerItem mediaInfo;
        logger.debug("ZLM HOOK on_publish API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        String mediaServerId = json.getString("mediaServerId");
        ZLMHttpHookSubscribe.Event subscribe = this.subscribe.getSubscribe(ZLMHttpHookSubscribe.HookType.on_publish, json);
        if (subscribe != null && (mediaInfo = this.mediaServerService.getOne(mediaServerId)) != null) {
            subscribe.response(mediaInfo, json);
        }
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("msg", (Object)"success");
        ret.put("enableHls", (Object)true);
        ret.put("enableMP4", (Object)this.userSetup.isRecordPushLive());
        ret.put("enableRtxp", (Object)true);
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_record_mp4"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onRecordMp4(@RequestBody JSONObject json) {
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_record_mp4 API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        }
        String mediaServerId = json.getString("mediaServerId");
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("msg", (Object)"success");
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_rtsp_realm"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onRtspRealm(@RequestBody JSONObject json) {
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_rtsp_realm API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        }
        String mediaServerId = json.getString("mediaServerId");
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("realm", (Object)"");
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_rtsp_auth"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onRtspAuth(@RequestBody JSONObject json) {
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_rtsp_auth API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        }
        String mediaServerId = json.getString("mediaServerId");
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("encrypted", (Object)false);
        ret.put("passwd", (Object)"test");
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_shell_login"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onShellLogin(@RequestBody JSONObject json) {
        MediaServerItem mediaInfo;
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_shell_login API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        }
        String mediaServerId = json.getString("mediaServerId");
        ZLMHttpHookSubscribe.Event subscribe = this.subscribe.getSubscribe(ZLMHttpHookSubscribe.HookType.on_shell_login, json);
        if (subscribe != null && (mediaInfo = this.mediaServerService.getOne(mediaServerId)) != null) {
            subscribe.response(mediaInfo, json);
        }
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("msg", (Object)"success");
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_stream_changed"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onStreamChanged(@RequestBody JSONObject json) {
        MediaServerItem mediaInfo;
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_stream_changed API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        }
        String mediaServerId = json.getString("mediaServerId");
        ZLMHttpHookSubscribe.Event subscribe = this.subscribe.getSubscribe(ZLMHttpHookSubscribe.HookType.on_stream_changed, json);
        if (subscribe != null && (mediaInfo = this.mediaServerService.getOne(mediaServerId)) != null) {
            subscribe.response(mediaInfo, json);
        }
        String app = json.getString("app");
        String streamId = json.getString("stream");
        String schema = json.getString("schema");
        JSONArray tracks = json.getJSONArray("tracks");
        boolean regist = json.getBoolean("regist");
        if (tracks != null) {
            logger.info("[stream: " + streamId + "] on_stream_changed->>" + schema);
        }
        if ("rtmp".equals(schema)) {
            if (regist) {
                this.mediaServerService.addCount(mediaServerId);
            } else {
                this.mediaServerService.removeCount(mediaServerId);
            }
            if ("rtp".equals(app) && !regist) {
                StreamInfo streamInfo = this.redisCatchStorage.queryPlayByStreamId(streamId);
                if (streamInfo != null) {
                    this.redisCatchStorage.stopPlay(streamInfo);
                    this.storager.stopPlay(streamInfo.getDeviceID(), streamInfo.getChannelId());
                } else {
                    streamInfo = this.redisCatchStorage.queryPlaybackByStreamId(streamId);
                    this.redisCatchStorage.stopPlayback(streamInfo);
                }
            } else if (!"rtp".equals(app)) {
                MediaServerItem mediaServerItem = this.mediaServerService.getOne(mediaServerId);
                if (regist) {
                    this.zlmMediaListManager.addMedia(mediaServerItem, app, streamId);
                } else {
                    this.zlmMediaListManager.removeMedia(app, streamId);
                }
            }
        }
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("msg", (Object)"success");
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_stream_none_reader"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onStreamNoneReader(@RequestBody JSONObject json) {
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_stream_none_reader API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        }
        String mediaServerId = json.getString("mediaServerId");
        String streamId = json.getString("stream");
        String app = json.getString("app");
        if ("rtp".equals(app)) {
            JSONObject ret = new JSONObject();
            ret.put("code", (Object)0);
            ret.put("close", (Object)true);
            StreamInfo streamInfoForPlayCatch = this.redisCatchStorage.queryPlayByStreamId(streamId);
            if (streamInfoForPlayCatch != null) {
                if (this.redisCatchStorage.isChannelSendingRTP(streamInfoForPlayCatch.getChannelId())) {
                    ret.put("close", (Object)false);
                } else {
                    this.cmder.streamByeCmd(streamInfoForPlayCatch.getDeviceID(), streamInfoForPlayCatch.getChannelId());
                    this.redisCatchStorage.stopPlay(streamInfoForPlayCatch);
                    this.storager.stopPlay(streamInfoForPlayCatch.getDeviceID(), streamInfoForPlayCatch.getChannelId());
                }
            } else {
                StreamInfo streamInfoForPlayBackCatch = this.redisCatchStorage.queryPlaybackByStreamId(streamId);
                if (streamInfoForPlayBackCatch != null) {
                    this.cmder.streamByeCmd(streamInfoForPlayBackCatch.getDeviceID(), streamInfoForPlayBackCatch.getChannelId());
                    this.redisCatchStorage.stopPlayback(streamInfoForPlayBackCatch);
                }
            }
            MediaServerItem mediaServerItem = this.mediaServerService.getOne(mediaServerId);
            if (mediaServerItem != null && "-1".equals(mediaServerItem.getStreamNoneReaderDelayMS())) {
                ret.put("close", (Object)false);
            }
            return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
        }
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("close", (Object)false);
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_stream_not_found"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onStreamNotFound(@RequestBody JSONObject json) {
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_stream_not_found API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + json.toString());
        }
        String mediaServerId = json.getString("mediaServerId");
        MediaServerItem mediaInfo = this.mediaServerService.getOne(mediaServerId);
        if (this.userSetup.isAutoApplyPlay().booleanValue() && mediaInfo != null) {
            String[] s;
            String app = json.getString("app");
            String streamId = json.getString("stream");
            if ("rtp".equals(app) && (s = streamId.split("_")).length == 2) {
                String deviceId = s[0];
                String channelId = s[1];
                Device device = this.storager.queryVideoDevice(deviceId);
                if (device != null) {
                    UUID uuid = UUID.randomUUID();
                    String streamId2 = null;
                    if (mediaInfo.isRtpEnable()) {
                        streamId2 = String.format("%s_%s", device.getDeviceId(), channelId);
                    }
                    SSRCInfo ssrcInfo = this.mediaServerService.openRTPServer(mediaInfo, streamId2);
                    this.cmder.playStreamCmd(mediaInfo, ssrcInfo, device, channelId, (mediaServerItemInuse, response) -> {
                        logger.info("\u6536\u5230\u8ba2\u9605\u6d88\u606f\uff1a " + response.toJSONString());
                        this.playService.onPublishHandlerForPlay(mediaServerItemInuse, response, deviceId, channelId, uuid.toString());
                    }, null);
                }
            }
        }
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("msg", (Object)"success");
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @PostMapping(value={"/on_server_started"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onServerStarted(HttpServletRequest request, @RequestBody JSONObject jsonObject) {
        if (logger.isDebugEnabled()) {
            logger.debug("ZLM HOOK on_server_started API\u8c03\u7528\uff0c\u53c2\u6570\uff1a" + jsonObject.toString());
        }
        String remoteAddr = request.getRemoteAddr();
        jsonObject.put("ip", (Object)remoteAddr);
        List subscribes = this.subscribe.getSubscribes(ZLMHttpHookSubscribe.HookType.on_server_started);
        if (subscribes != null && subscribes.size() > 0) {
            for (ZLMHttpHookSubscribe.Event subscribe : subscribes) {
                subscribe.response(null, jsonObject);
            }
        }
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("msg", (Object)"success");
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }
}

