/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.media.zlm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.conf.MediaConfig;
import com.genersoft.iot.vmp.media.zlm.ZLMHttpHookSubscribe;
import com.genersoft.iot.vmp.media.zlm.ZLMRESTfulUtils;
import com.genersoft.iot.vmp.media.zlm.ZLMServerConfig;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.IStreamProxyService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class ZLMRunner
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(ZLMRunner.class);
    private Map<String, Boolean> startGetMedia;
    @Autowired
    private ZLMRESTfulUtils zlmresTfulUtils;
    @Autowired
    private ZLMHttpHookSubscribe hookSubscribe;
    @Autowired
    private IStreamProxyService streamProxyService;
    @Autowired
    private IMediaServerService mediaServerService;
    @Autowired
    private MediaConfig mediaConfig;

    public void run(String ... strings) throws Exception {
        this.mediaServerService.clearMediaServerForOnline();
        this.hookSubscribe.addSubscribe(ZLMHttpHookSubscribe.HookType.on_server_started, null, (mediaServerItem, response) -> {
            ZLMServerConfig zlmServerConfig = (ZLMServerConfig)JSONObject.toJavaObject((JSON)response, ZLMServerConfig.class);
            if (zlmServerConfig != null) {
                this.startGetMedia.remove(zlmServerConfig.getGeneralMediaServerId());
                this.mediaServerService.handLeZLMServerConfig(zlmServerConfig);
            }
        });
        logger.info("\u7b49\u5f85\u9ed8\u8ba4zlm\u63a5\u5165...");
        List all = this.mediaServerService.getAllFromDatabase();
        if (all.size() == 0) {
            all.add(this.mediaConfig.getMediaSerItem());
        }
        for (MediaServerItem mediaServerItem2 : all) {
            if (this.startGetMedia == null) {
                this.startGetMedia = new HashMap();
            }
            this.startGetMedia.put(mediaServerItem2.getId(), true);
            new Thread(() -> {
                ZLMServerConfig zlmServerConfig = this.getMediaServerConfig(mediaServerItem2);
                if (zlmServerConfig != null) {
                    zlmServerConfig.setIp(mediaServerItem2.getIp());
                    zlmServerConfig.setHttpPort(mediaServerItem2.getHttpPort());
                    this.startGetMedia.remove(mediaServerItem2.getId());
                    this.mediaServerService.handLeZLMServerConfig(zlmServerConfig);
                }
            }).start();
        }
        Timer timer = new Timer();
        timer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 120000L);
    }

    public ZLMServerConfig getMediaServerConfig(MediaServerItem mediaServerItem) {
        if (this.startGetMedia == null) {
            return null;
        }
        if (!mediaServerItem.isDefaultServer() && this.mediaServerService.getOne(mediaServerItem.getId()) == null) {
            return null;
        }
        if (this.startGetMedia.get(mediaServerItem.getId()) == null || !((Boolean)this.startGetMedia.get(mediaServerItem.getId())).booleanValue()) {
            return null;
        }
        JSONObject responseJSON = this.zlmresTfulUtils.getMediaServerConfig(mediaServerItem);
        ZLMServerConfig ZLMServerConfig2 = null;
        if (responseJSON != null) {
            JSONArray data = responseJSON.getJSONArray("data");
            if (data != null && data.size() > 0) {
                ZLMServerConfig2 = (ZLMServerConfig)JSON.parseObject((String)JSON.toJSONString((Object)data.get(0)), ZLMServerConfig.class);
                ZLMServerConfig2.setIp(mediaServerItem.getIp());
            }
        } else {
            logger.error("[ {} ]-[ {}:{} ]\u4e3b\u52a8\u8fde\u63a5\u5931\u8d25\u5931\u8d25, 2s\u540e\u91cd\u8bd5", new Object[]{mediaServerItem.getId(), mediaServerItem.getIp(), mediaServerItem.getHttpPort()});
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ZLMServerConfig2 = this.getMediaServerConfig(mediaServerItem);
        }
        return ZLMServerConfig2;
    }

    static /* synthetic */ Map access$000(ZLMRunner x0) {
        return x0.startGetMedia;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ Map access$002(ZLMRunner x0, Map x1) {
        x0.startGetMedia = x1;
        return x0.startGetMedia;
    }
}

