/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.media.zlm.dto;

import com.genersoft.iot.vmp.gb28181.session.SsrcConfig;
import com.genersoft.iot.vmp.media.zlm.ZLMServerConfig;
import java.util.HashMap;
import org.springframework.util.StringUtils;

public class MediaServerItem {
    private String id;
    private String ip;
    private String hookIp;
    private String sdpIp;
    private String streamIp;
    private int httpPort;
    private int httpSSlPort;
    private int rtmpPort;
    private int rtmpSSlPort;
    private int rtpProxyPort;
    private int rtspPort;
    private int rtspSSLPort;
    private boolean autoConfig;
    private String secret;
    private String streamNoneReaderDelayMS;
    private boolean rtpEnable;
    private boolean status;
    private String rtpPortRange;
    private String sendRtpPortRange;
    private int recordAssistPort;
    private String createTime;
    private String updateTime;
    private String lastKeepaliveTime;
    private boolean defaultServer;
    private SsrcConfig ssrcConfig;
    private int currentPort;
    private HashMap<String, SsrcConfig> mediaServerSsrcMap;

    public MediaServerItem() {
    }

    public MediaServerItem(ZLMServerConfig zlmServerConfig, String sipIp) {
        this.id = zlmServerConfig.getGeneralMediaServerId();
        this.ip = zlmServerConfig.getIp();
        this.hookIp = StringUtils.isEmpty((Object)zlmServerConfig.getHookIp()) ? sipIp : zlmServerConfig.getHookIp();
        this.sdpIp = StringUtils.isEmpty((Object)zlmServerConfig.getSdpIp()) ? zlmServerConfig.getIp() : zlmServerConfig.getSdpIp();
        this.streamIp = StringUtils.isEmpty((Object)zlmServerConfig.getStreamIp()) ? zlmServerConfig.getIp() : zlmServerConfig.getStreamIp();
        this.httpPort = zlmServerConfig.getHttpPort();
        this.httpSSlPort = zlmServerConfig.getHttpSSLport();
        this.rtmpPort = zlmServerConfig.getRtmpPort();
        this.rtmpSSlPort = zlmServerConfig.getRtmpSslPort();
        this.rtpProxyPort = zlmServerConfig.getRtpProxyPort();
        this.rtspPort = zlmServerConfig.getRtspPort();
        this.rtspSSLPort = zlmServerConfig.getRtspSSlport();
        this.autoConfig = true;
        this.secret = zlmServerConfig.getApiSecret();
        this.streamNoneReaderDelayMS = zlmServerConfig.getGeneralStreamNoneReaderDelayMS();
        this.rtpEnable = false;
        this.rtpPortRange = "30000,30500";
        this.sendRtpPortRange = "30000,30500";
        this.recordAssistPort = 0;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getHookIp() {
        return this.hookIp;
    }

    public void setHookIp(String hookIp) {
        this.hookIp = hookIp;
    }

    public String getSdpIp() {
        return this.sdpIp;
    }

    public void setSdpIp(String sdpIp) {
        this.sdpIp = sdpIp;
    }

    public String getStreamIp() {
        return this.streamIp;
    }

    public void setStreamIp(String streamIp) {
        this.streamIp = streamIp;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpSSlPort() {
        return this.httpSSlPort;
    }

    public void setHttpSSlPort(int httpSSlPort) {
        this.httpSSlPort = httpSSlPort;
    }

    public int getRtmpPort() {
        return this.rtmpPort;
    }

    public void setRtmpPort(int rtmpPort) {
        this.rtmpPort = rtmpPort;
    }

    public int getRtmpSSlPort() {
        return this.rtmpSSlPort;
    }

    public void setRtmpSSlPort(int rtmpSSlPort) {
        this.rtmpSSlPort = rtmpSSlPort;
    }

    public int getRtpProxyPort() {
        return this.rtpProxyPort;
    }

    public void setRtpProxyPort(int rtpProxyPort) {
        this.rtpProxyPort = rtpProxyPort;
    }

    public int getRtspPort() {
        return this.rtspPort;
    }

    public void setRtspPort(int rtspPort) {
        this.rtspPort = rtspPort;
    }

    public int getRtspSSLPort() {
        return this.rtspSSLPort;
    }

    public void setRtspSSLPort(int rtspSSLPort) {
        this.rtspSSLPort = rtspSSLPort;
    }

    public boolean isAutoConfig() {
        return this.autoConfig;
    }

    public void setAutoConfig(boolean autoConfig) {
        this.autoConfig = autoConfig;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getStreamNoneReaderDelayMS() {
        return this.streamNoneReaderDelayMS;
    }

    public void setStreamNoneReaderDelayMS(String streamNoneReaderDelayMS) {
        this.streamNoneReaderDelayMS = streamNoneReaderDelayMS;
    }

    public boolean isRtpEnable() {
        return this.rtpEnable;
    }

    public void setRtpEnable(boolean rtpEnable) {
        this.rtpEnable = rtpEnable;
    }

    public String getRtpPortRange() {
        return this.rtpPortRange;
    }

    public void setRtpPortRange(String rtpPortRange) {
        this.rtpPortRange = rtpPortRange;
    }

    public int getRecordAssistPort() {
        return this.recordAssistPort;
    }

    public void setRecordAssistPort(int recordAssistPort) {
        this.recordAssistPort = recordAssistPort;
    }

    public boolean isDefaultServer() {
        return this.defaultServer;
    }

    public void setDefaultServer(boolean defaultServer) {
        this.defaultServer = defaultServer;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public HashMap<String, SsrcConfig> getMediaServerSsrcMap() {
        return this.mediaServerSsrcMap;
    }

    public void setMediaServerSsrcMap(HashMap<String, SsrcConfig> mediaServerSsrcMap) {
        this.mediaServerSsrcMap = mediaServerSsrcMap;
    }

    public SsrcConfig getSsrcConfig() {
        return this.ssrcConfig;
    }

    public void setSsrcConfig(SsrcConfig ssrcConfig) {
        this.ssrcConfig = ssrcConfig;
    }

    public int getCurrentPort() {
        return this.currentPort;
    }

    public void setCurrentPort(int currentPort) {
        this.currentPort = currentPort;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getLastKeepaliveTime() {
        return this.lastKeepaliveTime;
    }

    public void setLastKeepaliveTime(String lastKeepaliveTime) {
        this.lastKeepaliveTime = lastKeepaliveTime;
    }

    public String getSendRtpPortRange() {
        return this.sendRtpPortRange;
    }

    public void setSendRtpPortRange(String sendRtpPortRange) {
        this.sendRtpPortRange = sendRtpPortRange;
    }
}

