/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.service.impl;

import com.genersoft.iot.vmp.conf.DynamicTask;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.ISIPCommander;
import com.genersoft.iot.vmp.service.IDeviceService;
import com.genersoft.iot.vmp.service.bean.CatalogSubscribeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceServiceImpl
implements IDeviceService {
    private static final Logger logger = LoggerFactory.getLogger(DeviceServiceImpl.class);
    @Autowired
    private DynamicTask dynamicTask;
    @Autowired
    private ISIPCommander sipCommander;

    public boolean addCatalogSubscribe(Device device) {
        if (device == null || device.getSubscribeCycleForCatalog() < 0) {
            return false;
        }
        CatalogSubscribeTask catalogSubscribeTask = new CatalogSubscribeTask(device, this.sipCommander);
        catalogSubscribeTask.run();
        int subscribeCycleForCatalog = device.getSubscribeCycleForCatalog();
        subscribeCycleForCatalog = Math.max(subscribeCycleForCatalog, 30);
        this.dynamicTask.startCron(device.getDeviceId(), (Runnable)catalogSubscribeTask, subscribeCycleForCatalog - 5);
        return true;
    }

    public boolean removeCatalogSubscribe(Device device) {
        if (device == null || device.getSubscribeCycleForCatalog() < 0) {
            return false;
        }
        logger.info("\u79fb\u9664\u76ee\u5f55\u8ba2\u9605: {}", (Object)device.getDeviceId());
        this.dynamicTask.stopCron(device.getDeviceId());
        device.setSubscribeCycleForCatalog(0);
        this.sipCommander.catalogSubscribe(device, null, null);
        return true;
    }
}

