/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.service.impl;

import com.genersoft.iot.vmp.gb28181.bean.GbStream;
import com.genersoft.iot.vmp.gb28181.bean.PlatformGbStream;
import com.genersoft.iot.vmp.service.IGbStreamService;
import com.genersoft.iot.vmp.storager.dao.GbStreamMapper;
import com.genersoft.iot.vmp.storager.dao.PlatformGbStreamMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

@Service
public class GbStreamServiceImpl
implements IGbStreamService {
    private static final Logger logger = LoggerFactory.getLogger(GbStreamServiceImpl.class);
    @Autowired
    DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    TransactionDefinition transactionDefinition;
    @Autowired
    private GbStreamMapper gbStreamMapper;
    @Autowired
    private PlatformGbStreamMapper platformGbStreamMapper;

    public PageInfo<GbStream> getAll(Integer page, Integer count) {
        PageHelper.startPage((int)page, (int)count);
        List all = this.gbStreamMapper.selectAll();
        return new PageInfo(all);
    }

    public void del(String app, String stream) {
        this.gbStreamMapper.del(app, stream);
    }

    public boolean addPlatformInfo(List<GbStream> gbStreams, String platformId) {
        boolean result = false;
        TransactionStatus transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
        try {
            for (GbStream gbStream : gbStreams) {
                gbStream.setPlatformId(platformId);
                this.platformGbStreamMapper.add((PlatformGbStream)gbStream);
            }
            this.dataSourceTransactionManager.commit(transactionStatus);
            result = true;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u4fdd\u5b58\u6d41\u4e0e\u5e73\u53f0\u7684\u5173\u7cfb\u65f6\u9519\u8bef", (Throwable)e);
            this.dataSourceTransactionManager.rollback(transactionStatus);
        }
        return result;
    }

    public boolean delPlatformInfo(List<GbStream> gbStreams) {
        boolean result = false;
        TransactionStatus transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
        try {
            for (GbStream gbStream : gbStreams) {
                this.platformGbStreamMapper.delByAppAndStream(gbStream.getApp(), gbStream.getStream());
            }
            this.dataSourceTransactionManager.commit(transactionStatus);
            result = true;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u79fb\u9664\u6d41\u4e0e\u5e73\u53f0\u7684\u5173\u7cfb\u65f6\u9519\u8bef", (Throwable)e);
            this.dataSourceTransactionManager.rollback(transactionStatus);
        }
        return result;
    }
}

