/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.genersoft.iot.vmp.gb28181.bean.GbStream;
import com.genersoft.iot.vmp.media.zlm.ZLMRESTfulUtils;
import com.genersoft.iot.vmp.media.zlm.dto.MediaItem;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.media.zlm.dto.StreamPushItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.IStreamPushService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.dao.GbStreamMapper;
import com.genersoft.iot.vmp.storager.dao.StreamPushMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreamPushServiceImpl
implements IStreamPushService {
    @Autowired
    private GbStreamMapper gbStreamMapper;
    @Autowired
    private StreamPushMapper streamPushMapper;
    @Autowired
    private ZLMRESTfulUtils zlmresTfulUtils;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private IMediaServerService mediaServerService;

    public List<StreamPushItem> handleJSON(String jsonData, MediaServerItem mediaServerItem) {
        if (jsonData == null) {
            return null;
        }
        HashMap<String, StreamPushItem> result = new HashMap<String, StreamPushItem>();
        List mediaItems = (List)JSON.parseObject((String)jsonData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        for (MediaItem item : mediaItems) {
            String key;
            StreamPushItem streamPushItem;
            if (item.getOriginType() == 3 || item.getOriginType() == 4 || item.getOriginType() == 5 || (streamPushItem = (StreamPushItem)result.get(key = item.getApp() + "_" + item.getStream())) != null) continue;
            streamPushItem = new StreamPushItem();
            streamPushItem.setApp(item.getApp());
            streamPushItem.setMediaServerId(mediaServerItem.getId());
            streamPushItem.setStream(item.getStream());
            streamPushItem.setAliveSecond(item.getAliveSecond());
            streamPushItem.setCreateStamp(item.getCreateStamp());
            streamPushItem.setOriginSock(item.getOriginSock());
            streamPushItem.setTotalReaderCount(item.getTotalReaderCount());
            streamPushItem.setOriginType(item.getOriginType());
            streamPushItem.setOriginTypeStr(item.getOriginTypeStr());
            streamPushItem.setOriginUrl(item.getOriginUrl());
            streamPushItem.setCreateStamp(item.getCreateStamp());
            streamPushItem.setAliveSecond(item.getAliveSecond());
            streamPushItem.setStatus(true);
            streamPushItem.setVhost(item.getVhost());
            result.put(key, streamPushItem);
        }
        return new ArrayList<StreamPushItem>(result.values());
    }

    public PageInfo<StreamPushItem> getPushList(Integer page, Integer count) {
        PageHelper.startPage((int)page, (int)count);
        List all = this.streamPushMapper.selectAll();
        return new PageInfo(all);
    }

    public boolean saveToGB(GbStream stream) {
        stream.setStreamType("push");
        stream.setStatus(true);
        int add = this.gbStreamMapper.add(stream);
        return add > 0;
    }

    public boolean removeFromGB(GbStream stream) {
        int del = this.gbStreamMapper.del(stream.getApp(), stream.getStream());
        MediaServerItem mediaInfo = this.mediaServerService.getOne(stream.getMediaServerId());
        JSONObject mediaList = this.zlmresTfulUtils.getMediaList(mediaInfo, stream.getApp(), stream.getStream());
        if (mediaList == null) {
            this.streamPushMapper.del(stream.getApp(), stream.getStream());
        }
        return del > 0;
    }
}

