/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.storager.impl;

import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.gb28181.bean.GbStream;
import com.genersoft.iot.vmp.gb28181.bean.MobilePosition;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatformCatch;
import com.genersoft.iot.vmp.gb28181.session.VideoStreamSessionManager;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.media.zlm.dto.StreamProxyItem;
import com.genersoft.iot.vmp.media.zlm.dto.StreamPushItem;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.storager.dao.DeviceChannelMapper;
import com.genersoft.iot.vmp.storager.dao.DeviceMapper;
import com.genersoft.iot.vmp.storager.dao.DeviceMobilePositionMapper;
import com.genersoft.iot.vmp.storager.dao.GbStreamMapper;
import com.genersoft.iot.vmp.storager.dao.MediaServerMapper;
import com.genersoft.iot.vmp.storager.dao.ParentPlatformMapper;
import com.genersoft.iot.vmp.storager.dao.PlatformChannelMapper;
import com.genersoft.iot.vmp.storager.dao.StreamProxyMapper;
import com.genersoft.iot.vmp.storager.dao.StreamPushMapper;
import com.genersoft.iot.vmp.vmanager.gb28181.platform.bean.ChannelReduce;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;

@Component
public class VideoManagerStoragerImpl
implements IVideoManagerStorager {
    private Logger logger = LoggerFactory.getLogger(VideoManagerStoragerImpl.class);
    @Autowired
    DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    TransactionDefinition transactionDefinition;
    @Autowired
    private DeviceMapper deviceMapper;
    @Autowired
    private DeviceChannelMapper deviceChannelMapper;
    @Autowired
    private DeviceMobilePositionMapper deviceMobilePositionMapper;
    @Autowired
    private ParentPlatformMapper platformMapper;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private PlatformChannelMapper platformChannelMapper;
    @Autowired
    private StreamProxyMapper streamProxyMapper;
    @Autowired
    private StreamPushMapper streamPushMapper;
    @Autowired
    private GbStreamMapper gbStreamMapper;
    @Autowired
    private VideoStreamSessionManager streamSession;
    @Autowired
    private MediaServerMapper mediaServerMapper;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public boolean exists(String deviceId) {
        return this.deviceMapper.getDeviceByDeviceId(deviceId) != null;
    }

    public synchronized boolean create(Device device) {
        return this.deviceMapper.add(device) > 0;
    }

    public synchronized boolean updateDevice(Device device) {
        String now = this.format.format(System.currentTimeMillis());
        device.setUpdateTime(now);
        Device deviceByDeviceId = this.deviceMapper.getDeviceByDeviceId(device.getDeviceId());
        if (deviceByDeviceId == null) {
            device.setCreateTime(now);
            return this.deviceMapper.add(device) > 0;
        }
        return this.deviceMapper.update(device) > 0;
    }

    public synchronized void updateChannel(String deviceId, DeviceChannel channel) {
        String channelId = channel.getChannelId();
        channel.setDeviceId(deviceId);
        channel.setStreamId(this.streamSession.getStreamId(deviceId, channel.getChannelId()));
        String now = this.format.format(System.currentTimeMillis());
        channel.setUpdateTime(now);
        DeviceChannel deviceChannel = this.deviceChannelMapper.queryChannel(deviceId, channelId);
        if (deviceChannel == null) {
            channel.setCreateTime(now);
            this.deviceChannelMapper.add(channel);
        } else {
            this.deviceChannelMapper.update(channel);
        }
    }

    public void deviceChannelOnline(String deviceId, String channelId) {
        this.deviceChannelMapper.online(deviceId, channelId);
    }

    public void deviceChannelOffline(String deviceId, String channelId) {
        this.deviceChannelMapper.offline(deviceId, channelId);
    }

    public void startPlay(String deviceId, String channelId, String streamId) {
        this.deviceChannelMapper.startPlay(deviceId, channelId, streamId);
    }

    public void stopPlay(String deviceId, String channelId) {
        this.deviceChannelMapper.stopPlay(deviceId, channelId);
    }

    public Device queryVideoDevice(String deviceId) {
        return this.deviceMapper.getDeviceByDeviceId(deviceId);
    }

    public PageInfo queryChannelsByDeviceId(String deviceId, String query, Boolean hasSubChannel, Boolean online, int page, int count) {
        PageHelper.startPage((int)page, (int)count);
        List all = this.deviceChannelMapper.queryChannelsByDeviceId(deviceId, null, query, hasSubChannel, online);
        return new PageInfo(all);
    }

    public List<DeviceChannel> queryChannelsByDeviceId(String deviceId) {
        return this.deviceChannelMapper.queryChannelsByDeviceId(deviceId, null, null, null, null);
    }

    public PageInfo<DeviceChannel> querySubChannels(String deviceId, String parentChannelId, String query, Boolean hasSubChannel, String online, int page, int count) {
        PageHelper.startPage((int)page, (int)count);
        List all = this.deviceChannelMapper.queryChannelsByDeviceId(deviceId, parentChannelId, null, null, null);
        return new PageInfo(all);
    }

    public DeviceChannel queryChannel(String deviceId, String channelId) {
        return this.deviceChannelMapper.queryChannel(deviceId, channelId);
    }

    public int delChannel(String deviceId, String channelId) {
        return this.deviceChannelMapper.del(deviceId, channelId);
    }

    public PageInfo<Device> queryVideoDeviceList(int page, int count) {
        PageHelper.startPage((int)page, (int)count);
        List all = this.deviceMapper.getDevices();
        return new PageInfo(all);
    }

    public List<Device> queryVideoDeviceList() {
        List deviceList = this.deviceMapper.getDevices();
        return deviceList;
    }

    public boolean delete(String deviceId) {
        TransactionStatus transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
        boolean result = false;
        try {
            if (this.platformChannelMapper.delChannelForDeviceId(deviceId) < 0 || this.deviceChannelMapper.cleanChannelsByDeviceId(deviceId) < 0 || this.deviceMapper.del(deviceId) < 0) {
                this.dataSourceTransactionManager.rollback(transactionStatus);
            }
            result = true;
            this.dataSourceTransactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(transactionStatus);
        }
        return result;
    }

    public synchronized boolean online(String deviceId) {
        Device device = this.deviceMapper.getDeviceByDeviceId(deviceId);
        if (device == null) {
            return false;
        }
        device.setOnline(1);
        this.logger.info("\u66f4\u65b0\u8bbe\u5907\u5728\u7ebf: " + deviceId);
        return this.deviceMapper.update(device) > 0;
    }

    public synchronized boolean outline(String deviceId) {
        this.logger.info("\u66f4\u65b0\u8bbe\u5907\u79bb\u7ebf: " + deviceId);
        Device device = this.deviceMapper.getDeviceByDeviceId(deviceId);
        if (device == null) {
            return false;
        }
        device.setOnline(0);
        return this.deviceMapper.update(device) > 0;
    }

    public synchronized boolean outlineForAll() {
        this.logger.info("\u66f4\u65b0\u6240\u6709\u8bbe\u5907\u79bb\u7ebf");
        int result = this.deviceMapper.outlineForAll();
        return result > 0;
    }

    public void cleanChannelsForDevice(String deviceId) {
        this.deviceChannelMapper.cleanChannelsByDeviceId(deviceId);
    }

    public synchronized boolean insertMobilePosition(MobilePosition mobilePosition) {
        return this.deviceMobilePositionMapper.insertNewPosition(mobilePosition) > 0;
    }

    public synchronized List<MobilePosition> queryMobilePositions(String deviceId, String startTime, String endTime) {
        return this.deviceMobilePositionMapper.queryPositionByDeviceIdAndTime(deviceId, startTime, endTime);
    }

    public boolean addParentPlatform(ParentPlatform parentPlatform) {
        int result = this.platformMapper.addParentPlatform(parentPlatform);
        return result > 0;
    }

    public boolean updateParentPlatform(ParentPlatform parentPlatform) {
        int result = 0;
        ParentPlatformCatch parentPlatformCatch = this.redisCatchStorage.queryPlatformCatchInfo(parentPlatform.getServerGBId());
        if (parentPlatform.getId() == null) {
            result = this.platformMapper.addParentPlatform(parentPlatform);
            if (parentPlatformCatch == null) {
                parentPlatformCatch = new ParentPlatformCatch();
                parentPlatformCatch.setParentPlatform(parentPlatform);
                parentPlatformCatch.setId(parentPlatform.getServerGBId());
            }
        } else {
            if (parentPlatformCatch == null) {
                ParentPlatform parentPlatById = this.platformMapper.getParentPlatById(parentPlatform.getId().intValue());
                parentPlatformCatch = this.redisCatchStorage.queryPlatformCatchInfo(parentPlatById.getServerGBId());
                parentPlatformCatch.setId(parentPlatform.getServerGBId());
                this.redisCatchStorage.delPlatformCatchInfo(parentPlatById.getServerGBId());
            }
            result = this.platformMapper.updateParentPlatform(parentPlatform);
        }
        parentPlatformCatch.setParentPlatform(parentPlatform);
        this.redisCatchStorage.updatePlatformCatchInfo(parentPlatformCatch);
        return result > 0;
    }

    @Transactional
    public boolean deleteParentPlatform(ParentPlatform parentPlatform) {
        int result = this.platformMapper.delParentPlatform(parentPlatform);
        this.platformChannelMapper.cleanChannelForGB(parentPlatform.getServerGBId());
        return result > 0;
    }

    public PageInfo<ParentPlatform> queryParentPlatformList(int page, int count) {
        PageHelper.startPage((int)page, (int)count);
        List all = this.platformMapper.getParentPlatformList();
        return new PageInfo(all);
    }

    public ParentPlatform queryParentPlatByServerGBId(String platformGbId) {
        return this.platformMapper.getParentPlatByServerGBId(platformGbId);
    }

    public List<ParentPlatform> queryEnableParentPlatformList(boolean enable) {
        return this.platformMapper.getEnableParentPlatformList(enable);
    }

    public void outlineForAllParentPlatform() {
        this.platformMapper.outlineForAllParentPlatform();
    }

    public PageInfo<ChannelReduce> queryAllChannelList(int page, int count, String query, Boolean online, Boolean channelType, String platformId, Boolean inPlatform) {
        PageHelper.startPage((int)page, (int)count);
        List all = this.deviceChannelMapper.queryChannelListInAll(query, online, channelType, platformId, inPlatform);
        return new PageInfo(all);
    }

    public List<ChannelReduce> queryChannelListInParentPlatform(String platformId) {
        return this.deviceChannelMapper.queryChannelListInAll(null, null, null, platformId, Boolean.valueOf(true));
    }

    public int updateChannelForGB(String platformId, List<ChannelReduce> channelReduces) {
        HashMap<String, ChannelReduce> deviceAndChannels = new HashMap<String, ChannelReduce>();
        for (ChannelReduce channelReduce : channelReduces) {
            deviceAndChannels.put(channelReduce.getDeviceId() + "_" + channelReduce.getChannelId(), channelReduce);
        }
        ArrayList deviceAndChannelList = new ArrayList(deviceAndChannels.keySet());
        List relatedPlatformchannels = this.platformChannelMapper.findChannelRelatedPlatform(platformId, deviceAndChannelList);
        if (relatedPlatformchannels != null) {
            deviceAndChannelList.removeAll(relatedPlatformchannels);
        }
        for (String relatedPlatformchannel : relatedPlatformchannels) {
            deviceAndChannels.remove(relatedPlatformchannel);
        }
        ArrayList channelReducesToAdd = new ArrayList(deviceAndChannels.values());
        int result = 0;
        if (channelReducesToAdd.size() > 0) {
            result = this.platformChannelMapper.addChannels(platformId, channelReducesToAdd);
        }
        return result;
    }

    public int delChannelForGB(String platformId, List<ChannelReduce> channelReduces) {
        int result = this.platformChannelMapper.delChannelForGB(platformId, channelReduces);
        return result;
    }

    public DeviceChannel queryChannelInParentPlatform(String platformId, String channelId) {
        DeviceChannel channel = this.platformChannelMapper.queryChannelInParentPlatform(platformId, channelId);
        return channel;
    }

    public Device queryVideoDeviceByPlatformIdAndChannelId(String platformId, String channelId) {
        Device device = this.platformChannelMapper.queryVideoDeviceByPlatformIdAndChannelId(platformId, channelId);
        return device;
    }

    public MobilePosition queryLatestPosition(String deviceId) {
        return this.deviceMobilePositionMapper.queryLatestPositionByDevice(deviceId);
    }

    public int clearMobilePositionsByDeviceId(String deviceId) {
        return this.deviceMobilePositionMapper.clearMobilePositionsByDeviceId(deviceId);
    }

    public boolean addStreamProxy(StreamProxyItem streamProxyItem) {
        TransactionStatus transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
        boolean result = false;
        streamProxyItem.setStreamType("proxy");
        streamProxyItem.setStatus(true);
        String now = this.format.format(System.currentTimeMillis());
        streamProxyItem.setCreateTime(now);
        try {
            if (this.gbStreamMapper.add((GbStream)streamProxyItem) < 0 || this.streamProxyMapper.add(streamProxyItem) < 0) {
                this.dataSourceTransactionManager.rollback(transactionStatus);
            }
            result = true;
            this.dataSourceTransactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            this.logger.error("\u5411\u6570\u636e\u5e93\u6dfb\u52a0\u6d41\u4ee3\u7406\u5931\u8d25\uff1a", (Throwable)e);
            this.dataSourceTransactionManager.rollback(transactionStatus);
        }
        return result;
    }

    public boolean updateStreamProxy(StreamProxyItem streamProxyItem) {
        TransactionStatus transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
        boolean result = false;
        streamProxyItem.setStreamType("proxy");
        try {
            if (this.gbStreamMapper.update((GbStream)streamProxyItem) < 0 || this.streamProxyMapper.update(streamProxyItem) < 0) {
                this.dataSourceTransactionManager.rollback(transactionStatus);
            }
            this.dataSourceTransactionManager.commit(transactionStatus);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dataSourceTransactionManager.rollback(transactionStatus);
        }
        return result;
    }

    public int deleteStreamProxy(String app, String stream) {
        return this.streamProxyMapper.del(app, stream);
    }

    public List<StreamProxyItem> getStreamProxyListForEnable(boolean enable) {
        return this.streamProxyMapper.selectForEnable(enable);
    }

    public PageInfo<StreamProxyItem> queryStreamProxyList(Integer page, Integer count) {
        PageHelper.startPage((int)page, (int)count);
        List all = this.streamProxyMapper.selectAll();
        return new PageInfo(all);
    }

    public GbStream queryStreamInParentPlatform(String platformId, String gbId) {
        return this.gbStreamMapper.queryStreamInPlatform(platformId, gbId);
    }

    public List<GbStream> queryGbStreamListInPlatform(String platformId) {
        return this.gbStreamMapper.queryGbStreamListInPlatform(platformId);
    }

    public StreamProxyItem queryStreamProxy(String app, String stream) {
        return this.streamProxyMapper.selectOne(app, stream);
    }

    public void updateMediaList(List<StreamPushItem> streamPushItems) {
        if (streamPushItems == null || streamPushItems.size() == 0) {
            return;
        }
        this.logger.info("updateMediaList:  " + streamPushItems.size());
        this.streamPushMapper.addAll(streamPushItems);
        for (int i = 0; i < streamPushItems.size(); ++i) {
            this.gbStreamMapper.setStatus(streamPushItems.get(i).getApp(), streamPushItems.get(i).getStream(), true);
        }
    }

    public void updateMedia(StreamPushItem streamPushItem) {
        this.streamPushMapper.del(streamPushItem.getApp(), streamPushItem.getStream());
        this.streamPushMapper.add(streamPushItem);
        this.gbStreamMapper.setStatus(streamPushItem.getApp(), streamPushItem.getStream(), true);
    }

    public void removeMedia(String app, String stream) {
        this.streamPushMapper.del(app, stream);
    }

    public void clearMediaList() {
        this.streamPushMapper.clear();
    }

    public void mediaOutline(String app, String streamId) {
        this.gbStreamMapper.setStatus(app, streamId, false);
    }

    public void updateParentPlatformStatus(String platformGbID, boolean online) {
        this.platformMapper.updateParentPlatformStatus(platformGbID, online);
    }

    public void updateMediaServer(MediaServerItem mediaServerItem) {
        String now = this.format.format(System.currentTimeMillis());
        mediaServerItem.setUpdateTime(now);
        if (this.mediaServerMapper.queryOne(mediaServerItem.getId()) != null) {
            this.mediaServerMapper.update(mediaServerItem);
        } else {
            mediaServerItem.setCreateTime(now);
            this.mediaServerMapper.add(mediaServerItem);
        }
    }

    public List<StreamProxyItem> getStreamProxyListForEnableInMediaServer(String id, boolean enable) {
        return this.streamProxyMapper.selectForEnableInMediaServer(id, enable);
    }

    public Device queryVideoDeviceByChannelId(String channelId) {
        Device result = null;
        List channelList = this.deviceChannelMapper.queryChannelByChannelId(channelId);
        if (channelList.size() == 1) {
            result = this.deviceMapper.getDeviceByDeviceId(((DeviceChannel)channelList.get(0)).getDeviceId());
        }
        return result;
    }
}

