/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.device;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.gb28181.event.DeviceOffLineDetector;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.service.IDeviceService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Api(tags={"\u56fd\u6807\u8bbe\u5907\u67e5\u8be2"}, value="\u56fd\u6807\u8bbe\u5907\u67e5\u8be2")
@CrossOrigin
@RestController
@RequestMapping(value={"/api/device/query"})
public class DeviceQuery {
    private static final Logger logger = LoggerFactory.getLogger(DeviceQuery.class);
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private DeferredResultHolder resultHolder;
    @Autowired
    private DeviceOffLineDetector offLineDetector;
    @Autowired
    private IDeviceService deviceService;

    @ApiOperation(value="\u4f7f\u7528ID\u67e5\u8be2\u56fd\u6807\u8bbe\u5907")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/devices/{deviceId}"})
    public ResponseEntity<Device> devices(@PathVariable String deviceId) {
        Device device = this.storager.queryVideoDevice(deviceId);
        return new ResponseEntity((Object)device, HttpStatus.OK);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u56fd\u6807\u8bbe\u5907")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="count", value="\u6bcf\u9875\u67e5\u8be2\u6570\u91cf", required=true, dataTypeClass=Integer.class)})
    @GetMapping(value={"/devices"})
    public PageInfo<Device> devices(int page, int count) {
        return this.storager.queryVideoDeviceList(page, count);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u901a\u9053")
    @GetMapping(value={"/devices/{deviceId}/channels"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907id", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="count", value="\u6bcf\u9875\u67e5\u8be2\u6570\u91cf", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="query", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="online", value="\u662f\u5426\u5728\u7ebf", dataTypeClass=Boolean.class), @ApiImplicitParam(name="channelType", value="\u8bbe\u5907/\u5b50\u76ee\u5f55-> false/true", dataTypeClass=Boolean.class)})
    public ResponseEntity<PageInfo> channels(@PathVariable String deviceId, int page, int count, @RequestParam(required=false) String query, @RequestParam(required=false) Boolean online, @RequestParam(required=false) Boolean channelType) {
        if (StringUtils.isEmpty((Object)query)) {
            query = null;
        }
        PageInfo pageResult = this.storager.queryChannelsByDeviceId(deviceId, query, channelType, online, page, count);
        return new ResponseEntity((Object)pageResult, HttpStatus.OK);
    }

    @ApiOperation(value="\u540c\u6b65\u8bbe\u5907\u901a\u9053")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907id", required=true, dataTypeClass=String.class)})
    @PostMapping(value={"/devices/{deviceId}/sync"})
    public DeferredResult<ResponseEntity<Device>> devicesSync(@PathVariable String deviceId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\u901a\u9053\u4fe1\u606f\u540c\u6b65API\u8c03\u7528\uff0cdeviceId\uff1a" + deviceId);
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        String key = "CALLBACK_CATALOG" + deviceId;
        String uuid = UUID.randomUUID().toString();
        DeferredResult result = new DeferredResult(Long.valueOf(15000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u8bbe\u5907\u901a\u9053\u4fe1\u606f\u540c\u6b65\u8d85\u65f6", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setKey(key);
            msg.setId(uuid);
            msg.setData((Object)"Timeout");
            this.resultHolder.invokeAllResult(msg);
        });
        if (this.resultHolder.exist(key, null)) {
            return result;
        }
        this.cmder.catalogQuery(device, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setKey(key);
            msg.setId(uuid);
            msg.setData((Object)String.format("\u540c\u6b65\u901a\u9053\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeAllResult(msg);
        });
        this.resultHolder.put(key, uuid, result);
        return result;
    }

    @ApiOperation(value="\u79fb\u9664\u8bbe\u5907")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907id", required=true, dataTypeClass=String.class)})
    @DeleteMapping(value={"/devices/{deviceId}/delete"})
    public ResponseEntity<String> delete(@PathVariable String deviceId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\u4fe1\u606f\u5220\u9664API\u8c03\u7528\uff0cdeviceId\uff1a" + deviceId);
        }
        if (this.offLineDetector.isOnline(deviceId)) {
            return new ResponseEntity((Object)"\u4e0d\u5141\u8bb8\u5220\u9664\u5728\u7ebf\u8bbe\u5907\uff01", HttpStatus.NOT_ACCEPTABLE);
        }
        boolean isSuccess = this.storager.delete(deviceId);
        if (isSuccess) {
            this.redisCatchStorage.clearCatchByDeviceId(deviceId);
            JSONObject json = new JSONObject();
            json.put("deviceId", (Object)deviceId);
            return new ResponseEntity((Object)json.toString(), HttpStatus.OK);
        }
        logger.warn("\u8bbe\u5907\u4fe1\u606f\u5220\u9664API\u8c03\u7528\u5931\u8d25\uff01");
        return new ResponseEntity((Object)"\u8bbe\u5907\u4fe1\u606f\u5220\u9664API\u8c03\u7528\u5931\u8d25\uff01", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5b50\u76ee\u5f55\u901a\u9053")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907id", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053id", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="count", value="\u6bcf\u9875\u6761\u6570", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="query", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="online", value="\u662f\u5426\u5728\u7ebf", dataTypeClass=String.class), @ApiImplicitParam(name="channelType", value="\u901a\u9053\u7c7b\u578b\uff0c \u5b50\u76ee\u5f55", dataTypeClass=Boolean.class)})
    @GetMapping(value={"/sub_channels/{deviceId}/{channelId}/channels"})
    public ResponseEntity<PageInfo> subChannels(@PathVariable String deviceId, @PathVariable String channelId, int page, int count, @RequestParam(required=false) String query, @RequestParam(required=false) String online, @RequestParam(required=false) Boolean channelType) {
        DeviceChannel deviceChannel = this.storager.queryChannel(deviceId, channelId);
        if (deviceChannel == null) {
            PageInfo deviceChannelPageResult = new PageInfo();
            return new ResponseEntity((Object)deviceChannelPageResult, HttpStatus.OK);
        }
        PageInfo pageResult = this.storager.querySubChannels(deviceId, channelId, query, channelType, online, page, count);
        return new ResponseEntity((Object)pageResult, HttpStatus.OK);
    }

    @ApiOperation(value="\u66f4\u65b0\u901a\u9053\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907id", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="channel", value="\u901a\u9053", required=true, dataTypeClass=String.class)})
    @PostMapping(value={"/channel/update/{deviceId}"})
    public ResponseEntity<PageInfo> updateChannel(@PathVariable String deviceId, DeviceChannel channel) {
        this.storager.updateChannel(deviceId, channel);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u6d41\u4f20\u8f93\u6a21\u5f0f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907id", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="streamMode", value="\u6570\u636e\u6d41\u4f20\u8f93\u6a21\u5f0f, \u53d6\u503c\uff1aUDP\uff08udp\u4f20\u8f93\uff09\uff0cTCP-ACTIVE\uff08tcp\u4e3b\u52a8\u6a21\u5f0f,\u6682\u4e0d\u652f\u6301\uff09\uff0cTCP-PASSIVE\uff08tcp\u88ab\u52a8\u6a21\u5f0f\uff09", dataTypeClass=String.class)})
    @PostMapping(value={"/transport/{deviceId}/{streamMode}"})
    public ResponseEntity<PageInfo> updateTransport(@PathVariable String deviceId, @PathVariable String streamMode) {
        Device device = this.storager.queryVideoDevice(deviceId);
        device.setStreamMode(streamMode);
        this.storager.updateDevice(device);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @ApiOperation(value="\u66f4\u65b0\u8bbe\u5907\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="device", value="\u8bbe\u5907\u4fe1\u606f", required=true, dataTypeClass=Device.class)})
    @PostMapping(value={"/device/update/"})
    public ResponseEntity<WVPResult<String>> updateDevice(Device device) {
        if (device != null && device.getDeviceId() != null) {
            Device deviceInStore = this.storager.queryVideoDevice(device.getDeviceId());
            if (!StringUtils.isEmpty((Object)device.getName())) {
                deviceInStore.setName(device.getName());
            }
            if (!StringUtils.isEmpty((Object)device.getCharset())) {
                deviceInStore.setCharset(device.getCharset());
            }
            if (!StringUtils.isEmpty((Object)device.getMediaServerId())) {
                deviceInStore.setMediaServerId(device.getMediaServerId());
            }
            if (deviceInStore.getSubscribeCycleForCatalog() <= 0 && device.getSubscribeCycleForCatalog() > 0) {
                deviceInStore.setSubscribeCycleForCatalog(device.getSubscribeCycleForCatalog());
                this.deviceService.addCatalogSubscribe(deviceInStore);
            }
            if (deviceInStore.getSubscribeCycleForCatalog() > 0 && device.getSubscribeCycleForCatalog() <= 0) {
                deviceInStore.setSubscribeCycleForCatalog(device.getSubscribeCycleForCatalog());
                this.deviceService.removeCatalogSubscribe(deviceInStore);
            }
            this.storager.updateDevice(deviceInStore);
            this.cmder.deviceInfoQuery(deviceInStore);
        }
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @ApiOperation(value="\u8bbe\u5907\u72b6\u6001\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907id", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/devices/{deviceId}/status"})
    public DeferredResult<ResponseEntity<String>> deviceStatusApi(@PathVariable String deviceId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\u72b6\u6001\u67e5\u8be2API\u8c03\u7528");
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        String uuid = UUID.randomUUID().toString();
        String key = "CALLBACK_DEVICESTATUS" + deviceId;
        this.cmder.deviceStatusQuery(device, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u83b7\u53d6\u8bbe\u5907\u72b6\u6001\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeResult(msg);
        });
        DeferredResult result = new DeferredResult(Long.valueOf(2000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u83b7\u53d6\u8bbe\u5907\u72b6\u6001\u8d85\u65f6", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"Timeout. Device did not response to this command.");
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put("CALLBACK_DEVICESTATUS" + deviceId, uuid, result);
        return result;
    }

    @ApiOperation(value="\u8bbe\u5907\u62a5\u8b66\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907id", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="startPriority", value="\u62a5\u8b66\u8d77\u59cb\u7ea7\u522b", dataTypeClass=String.class), @ApiImplicitParam(name="endPriority", value="\u62a5\u8b66\u7ec8\u6b62\u7ea7\u522b", dataTypeClass=String.class), @ApiImplicitParam(name="alarmMethod", value="\u62a5\u8b66\u65b9\u5f0f\u6761\u4ef6", dataTypeClass=String.class), @ApiImplicitParam(name="alarmType", value="\u62a5\u8b66\u7c7b\u578b", dataTypeClass=String.class), @ApiImplicitParam(name="startTime", value="\u62a5\u8b66\u53d1\u751f\u8d77\u59cb\u65f6\u95f4", dataTypeClass=String.class), @ApiImplicitParam(name="endTime", value="\u62a5\u8b66\u53d1\u751f\u7ec8\u6b62\u65f6\u95f4", dataTypeClass=String.class)})
    @GetMapping(value={"/alarm/{deviceId}"})
    public DeferredResult<ResponseEntity<String>> alarmApi(@PathVariable String deviceId, @RequestParam(required=false) String startPriority, @RequestParam(required=false) String endPriority, @RequestParam(required=false) String alarmMethod, @RequestParam(required=false) String alarmType, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\u62a5\u8b66\u67e5\u8be2API\u8c03\u7528");
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        String key = "CALLBACK_ALARM" + deviceId;
        String uuid = UUID.randomUUID().toString();
        this.cmder.alarmInfoQuery(device, startPriority, endPriority, alarmMethod, alarmType, startTime, endTime, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u8bbe\u5907\u62a5\u8b66\u67e5\u8be2\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeResult(msg);
        });
        DeferredResult result = new DeferredResult(Long.valueOf(3000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u8bbe\u5907\u62a5\u8b66\u67e5\u8be2\u8d85\u65f6", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"\u8bbe\u5907\u62a5\u8b66\u67e5\u8be2\u8d85\u65f6");
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put("CALLBACK_ALARM" + deviceId, uuid, result);
        return result;
    }
}

