/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.play;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.SsrcTransaction;
import com.genersoft.iot.vmp.gb28181.session.VideoStreamSessionManager;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.media.zlm.ZLMRESTfulUtils;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.IMediaService;
import com.genersoft.iot.vmp.service.IPlayService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import com.genersoft.iot.vmp.vmanager.gb28181.play.bean.PlayResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Api(tags={"\u56fd\u6807\u8bbe\u5907\u70b9\u64ad"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/play"})
public class PlayController {
    private static final Logger logger = LoggerFactory.getLogger(PlayController.class);
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private VideoStreamSessionManager streamSession;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private ZLMRESTfulUtils zlmresTfulUtils;
    @Autowired
    private DeferredResultHolder resultHolder;
    @Autowired
    private IPlayService playService;
    @Autowired
    private IMediaService mediaService;
    @Autowired
    private IMediaServerService mediaServerService;

    @ApiOperation(value="\u5f00\u59cb\u70b9\u64ad")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class)})
    @GetMapping(value={"/start/{deviceId}/{channelId}"})
    public DeferredResult<ResponseEntity<String>> play(@PathVariable String deviceId, @PathVariable String channelId) {
        Device device = this.storager.queryVideoDevice(deviceId);
        MediaServerItem newMediaServerItem = this.playService.getNewMediaServerItem(device);
        PlayResult playResult = this.playService.play(newMediaServerItem, deviceId, channelId, null, null);
        return playResult.getResult();
    }

    @ApiOperation(value="\u505c\u6b62\u70b9\u64ad")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class)})
    @GetMapping(value={"/stop/{deviceId}/{channelId}"})
    public DeferredResult<ResponseEntity<String>> playStop(@PathVariable String deviceId, @PathVariable String channelId) {
        logger.debug(String.format("\u8bbe\u5907\u9884\u89c8/\u56de\u653e\u505c\u6b62API\u8c03\u7528\uff0cstreamId\uff1a%s_%s", deviceId, channelId));
        String uuid = UUID.randomUUID().toString();
        DeferredResult result = new DeferredResult();
        String key = "CALLBACK_STOP" + deviceId + channelId;
        this.resultHolder.put(key, uuid, result);
        Device device = this.storager.queryVideoDevice(deviceId);
        this.cmder.streamByeCmd(deviceId, channelId, event -> {
            StreamInfo streamInfo = this.redisCatchStorage.queryPlayByDevice(deviceId, channelId);
            if (streamInfo == null) {
                RequestMessage msg = new RequestMessage();
                msg.setId(uuid);
                msg.setKey(key);
                msg.setData((Object)"\u70b9\u64ad\u672a\u627e\u5230");
                this.resultHolder.invokeAllResult(msg);
                this.storager.stopPlay(deviceId, channelId);
            } else {
                this.redisCatchStorage.stopPlay(streamInfo);
                this.storager.stopPlay(streamInfo.getDeviceID(), streamInfo.getChannelId());
                RequestMessage msg = new RequestMessage();
                msg.setId(uuid);
                msg.setKey(key);
                msg.setData((Object)String.format("success", new Object[0]));
                this.resultHolder.invokeAllResult(msg);
            }
            this.mediaServerService.closeRTPServer(device, channelId);
        });
        if (deviceId != null || channelId != null) {
            JSONObject json = new JSONObject();
            json.put("deviceId", (Object)deviceId);
            json.put("channelId", (Object)channelId);
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)json.toString());
            this.resultHolder.invokeAllResult(msg);
        } else {
            logger.warn("\u8bbe\u5907\u9884\u89c8/\u56de\u653e\u505c\u6b62API\u8c03\u7528\u5931\u8d25\uff01");
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"streamId null");
            this.resultHolder.invokeAllResult(msg);
        }
        result.onTimeout(() -> {
            logger.warn(String.format("\u8bbe\u5907\u9884\u89c8/\u56de\u653e\u505c\u6b62\u8d85\u65f6\uff0cdeviceId/channelId\uff1a%s_%s ", deviceId, channelId));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"Timeout");
            this.resultHolder.invokeAllResult(msg);
        });
        return result;
    }

    @ApiOperation(value="\u5c06\u4e0d\u662fh264\u7684\u89c6\u9891\u901a\u8fc7ffmpeg \u8f6c\u7801\u4e3ah264 + aac")
    @ApiImplicitParams(value={@ApiImplicitParam(name="streamId", value="\u89c6\u9891\u6d41ID", dataTypeClass=String.class)})
    @PostMapping(value={"/convert/{streamId}"})
    public ResponseEntity<String> playConvert(@PathVariable String streamId) {
        StreamInfo streamInfo = this.redisCatchStorage.queryPlayByStreamId(streamId);
        if (streamInfo == null) {
            streamInfo = this.redisCatchStorage.queryPlaybackByStreamId(streamId);
        }
        if (streamInfo == null) {
            logger.warn("\u89c6\u9891\u8f6c\u7801API\u8c03\u7528\u5931\u8d25\uff01, \u89c6\u9891\u6d41\u5df2\u7ecf\u505c\u6b62!");
            return new ResponseEntity((Object)"\u672a\u627e\u5230\u89c6\u9891\u6d41\u4fe1\u606f, \u89c6\u9891\u6d41\u53ef\u80fd\u5df2\u7ecf\u505c\u6b62", HttpStatus.OK);
        }
        MediaServerItem mediaInfo = this.mediaServerService.getOne(streamInfo.getMediaServerId());
        JSONObject rtpInfo = this.zlmresTfulUtils.getRtpInfo(mediaInfo, streamId);
        if (!rtpInfo.getBoolean("exist").booleanValue()) {
            logger.warn("\u89c6\u9891\u8f6c\u7801API\u8c03\u7528\u5931\u8d25\uff01, \u89c6\u9891\u6d41\u5df2\u505c\u6b62\u63a8\u6d41!");
            return new ResponseEntity((Object)"\u63a8\u6d41\u4fe1\u606f\u5728\u6d41\u5a92\u4f53\u4e2d\u4e0d\u5b58\u5728, \u89c6\u9891\u6d41\u53ef\u80fd\u5df2\u505c\u6b62\u63a8\u6d41", HttpStatus.OK);
        }
        String dstUrl = String.format("rtmp://%s:%s/convert/%s", "127.0.0.1", mediaInfo.getRtmpPort(), streamId);
        String srcUrl = String.format("rtsp://%s:%s/rtp/%s", "127.0.0.1", mediaInfo.getRtspPort(), streamId);
        JSONObject jsonObject = this.zlmresTfulUtils.addFFmpegSource(mediaInfo, srcUrl, dstUrl, "1000000", true, false, null);
        logger.info(jsonObject.toJSONString());
        JSONObject result = new JSONObject();
        if (jsonObject != null && jsonObject.getInteger("code") == 0) {
            result.put("code", (Object)0);
            JSONObject data = jsonObject.getJSONObject("data");
            if (data != null) {
                result.put("key", (Object)data.getString("key"));
                StreamInfo streamInfoResult = this.mediaService.getStreamInfoByAppAndStreamWithCheck("convert", streamId, mediaInfo.getId());
                result.put("data", (Object)streamInfoResult);
            }
        } else {
            result.put("code", (Object)1);
            result.put("msg", (Object)"cover fail");
        }
        return new ResponseEntity((Object)result.toJSONString(), HttpStatus.OK);
    }

    @ApiOperation(value="\u7ed3\u675f\u8f6c\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u89c6\u9891\u6d41key", dataTypeClass=String.class)})
    @PostMapping(value={"/convertStop/{key}"})
    public ResponseEntity<String> playConvertStop(@PathVariable String key, String mediaServerId) {
        JSONObject result = new JSONObject();
        if (mediaServerId == null) {
            result.put("code", (Object)400);
            result.put("msg", (Object)"mediaServerId is null");
            return new ResponseEntity((Object)result.toJSONString(), HttpStatus.BAD_REQUEST);
        }
        MediaServerItem mediaInfo = this.mediaServerService.getOne(mediaServerId);
        if (mediaInfo == null) {
            result.put("code", (Object)0);
            result.put("msg", (Object)"\u4f7f\u7528\u7684\u6d41\u5a92\u4f53\u5df2\u7ecf\u505c\u6b62\u8fd0\u884c");
            return new ResponseEntity((Object)result.toJSONString(), HttpStatus.OK);
        }
        JSONObject jsonObject = this.zlmresTfulUtils.delFFmpegSource(mediaInfo, key);
        logger.info(jsonObject.toJSONString());
        if (jsonObject != null && jsonObject.getInteger("code") == 0) {
            result.put("code", (Object)0);
            JSONObject data = jsonObject.getJSONObject("data");
            if (data != null && data.getBoolean("flag").booleanValue()) {
                result.put("code", (Object)"0");
                result.put("msg", (Object)"success");
            }
        } else {
            result.put("code", (Object)1);
            result.put("msg", (Object)"delFFmpegSource fail");
        }
        return new ResponseEntity((Object)result.toJSONString(), HttpStatus.OK);
    }

    @ApiOperation(value="\u8bed\u97f3\u5e7f\u64ad\u547d\u4ee4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907Id", dataTypeClass=String.class)})
    @GetMapping(value={"/broadcast/{deviceId}"})
    @PostMapping(value={"/broadcast/{deviceId}"})
    public DeferredResult<ResponseEntity<String>> broadcastApi(@PathVariable String deviceId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bed\u97f3\u5e7f\u64adAPI\u8c03\u7528");
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        DeferredResult result = new DeferredResult(Long.valueOf(3000L));
        String key = "CALLBACK_BROADCAST" + deviceId;
        if (this.resultHolder.exist(key, null)) {
            result.setResult((Object)new ResponseEntity((Object)"\u8bbe\u5907\u4f7f\u7528\u4e2d", HttpStatus.OK));
            return result;
        }
        String uuid = UUID.randomUUID().toString();
        if (device == null) {
            this.resultHolder.put(key, key, result);
            RequestMessage msg = new RequestMessage();
            msg.setKey(key);
            msg.setId(uuid);
            JSONObject json = new JSONObject();
            json.put("DeviceID", (Object)deviceId);
            json.put("CmdType", (Object)"Broadcast");
            json.put("Result", (Object)"Failed");
            json.put("Description", (Object)"Device \u4e0d\u5b58\u5728");
            msg.setData((Object)json);
            this.resultHolder.invokeResult(msg);
            return result;
        }
        this.cmder.audioBroadcastCmd(device, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setKey(key);
            msg.setId(uuid);
            JSONObject json = new JSONObject();
            json.put("DeviceID", (Object)deviceId);
            json.put("CmdType", (Object)"Broadcast");
            json.put("Result", (Object)"Failed");
            json.put("Description", (Object)String.format("\u8bed\u97f3\u5e7f\u64ad\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            msg.setData((Object)json);
            this.resultHolder.invokeResult(msg);
        });
        result.onTimeout(() -> {
            logger.warn(String.format("\u8bed\u97f3\u5e7f\u64ad\u64cd\u4f5c\u8d85\u65f6, \u8bbe\u5907\u672a\u8fd4\u56de\u5e94\u7b54\u6307\u4ee4", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setKey(key);
            msg.setId(uuid);
            JSONObject json = new JSONObject();
            json.put("DeviceID", (Object)deviceId);
            json.put("CmdType", (Object)"Broadcast");
            json.put("Result", (Object)"Failed");
            json.put("Error", (Object)"Timeout. Device did not response to broadcast command.");
            msg.setData((Object)json);
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put(key, uuid, result);
        return result;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684ssrc")
    @GetMapping(value={"/ssrc"})
    public WVPResult<JSONObject> getSSRC() {
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u6240\u6709\u7684ssrc");
        }
        JSONArray objects = new JSONArray();
        List allSsrc = this.streamSession.getAllSsrc();
        for (SsrcTransaction transaction : allSsrc) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("deviceId", (Object)transaction.getDeviceId());
            jsonObject.put("channelId", (Object)transaction.getChannelId());
            jsonObject.put("ssrc", (Object)transaction.getSsrc());
            jsonObject.put("streamId", (Object)transaction.getStreamId());
            objects.add((Object)jsonObject);
        }
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)objects);
        jsonObject.put("count", (Object)objects.size());
        result.setData((Object)jsonObject);
        return result;
    }
}

