/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.playback;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.IPlayService;
import com.genersoft.iot.vmp.service.bean.SSRCInfo;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Api(tags={"\u89c6\u9891\u56de\u653e"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/playback"})
public class PlaybackController {
    private static final Logger logger = LoggerFactory.getLogger(PlaybackController.class);
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private IPlayService playService;
    @Autowired
    private DeferredResultHolder resultHolder;
    @Autowired
    private IMediaServerService mediaServerService;

    @ApiOperation(value="\u5f00\u59cb\u89c6\u9891\u56de\u653e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", dataTypeClass=String.class), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", dataTypeClass=String.class)})
    @GetMapping(value={"/start/{deviceId}/{channelId}"})
    public DeferredResult<ResponseEntity<String>> play(@PathVariable String deviceId, @PathVariable String channelId, String startTime, String endTime) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u8bbe\u5907\u56de\u653e API\u8c03\u7528\uff0cdeviceId\uff1a%s \uff0cchannelId\uff1a%s", deviceId, channelId));
        }
        String uuid = UUID.randomUUID().toString();
        String key = "CALLBACK_PLAY" + deviceId + channelId;
        DeferredResult result = new DeferredResult(Long.valueOf(30000L));
        Device device = this.storager.queryVideoDevice(deviceId);
        if (device == null) {
            result.setResult((Object)new ResponseEntity(HttpStatus.BAD_REQUEST));
            return result;
        }
        MediaServerItem newMediaServerItem = this.playService.getNewMediaServerItem(device);
        SSRCInfo ssrcInfo = this.mediaServerService.openRTPServer(newMediaServerItem, null, true);
        result.onTimeout(() -> {
            logger.warn(String.format("\u8bbe\u5907\u56de\u653e\u8d85\u65f6\uff0cdeviceId\uff1a%s \uff0cchannelId\uff1a%s", deviceId, channelId));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"Timeout");
            this.resultHolder.invokeResult(msg);
        });
        StreamInfo streamInfo = this.redisCatchStorage.queryPlaybackByDevice(deviceId, channelId);
        if (streamInfo != null) {
            this.cmder.streamByeCmd(deviceId, channelId);
        }
        this.resultHolder.put("CALLBACK_PLAY" + deviceId + channelId, uuid, result);
        if (newMediaServerItem == null) {
            logger.warn(String.format("\u8bbe\u5907\u56de\u653e\u8d85\u65f6\uff0cdeviceId\uff1a%s \uff0cchannelId\uff1a%s", deviceId, channelId));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"Timeout");
            this.resultHolder.invokeResult(msg);
            return result;
        }
        this.cmder.playbackStreamCmd(newMediaServerItem, ssrcInfo, device, channelId, startTime, endTime, (mediaServerItem, response) -> {
            logger.info("\u6536\u5230\u8ba2\u9605\u6d88\u606f\uff1a " + response.toJSONString());
            this.playService.onPublishHandlerForPlayBack(mediaServerItem, response, deviceId, channelId, uuid.toString());
        }, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u56de\u653e\u5931\u8d25\uff0c \u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeResult(msg);
        });
        return result;
    }

    @ApiOperation(value="\u505c\u6b62\u89c6\u9891\u56de\u653e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class)})
    @GetMapping(value={"/stop/{deviceId}/{channelId}"})
    public ResponseEntity<String> playStop(@PathVariable String deviceId, @PathVariable String channelId) {
        this.cmder.streamByeCmd(deviceId, channelId);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u8bbe\u5907\u5f55\u50cf\u56de\u653e\u505c\u6b62 API\u8c03\u7528\uff0cdeviceId/channelId\uff1a%s/%s", deviceId, channelId));
        }
        if (deviceId != null && channelId != null) {
            JSONObject json = new JSONObject();
            json.put("deviceId", (Object)deviceId);
            json.put("channelId", (Object)channelId);
            return new ResponseEntity((Object)json.toString(), HttpStatus.OK);
        }
        logger.warn("\u8bbe\u5907\u5f55\u50cf\u56de\u653e\u505c\u6b62API\u8c03\u7528\u5931\u8d25\uff01");
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

