/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.record;

import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.RecordInfo;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Api(tags={"\u56fd\u6807\u5f55\u50cf"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/gb_record"})
public class GBRecordController {
    private static final Logger logger = LoggerFactory.getLogger(GBRecordController.class);
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private DeferredResultHolder resultHolder;

    @ApiOperation(value="\u5f55\u50cf\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", dataTypeClass=String.class), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", dataTypeClass=String.class)})
    @GetMapping(value={"/query/{deviceId}/{channelId}"})
    public DeferredResult<ResponseEntity<RecordInfo>> recordinfo(@PathVariable String deviceId, @PathVariable String channelId, String startTime, String endTime) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u5f55\u50cf\u4fe1\u606f\u67e5\u8be2 API\u8c03\u7528\uff0cdeviceId\uff1a%s \uff0cstartTime\uff1a%s\uff0c startTime\uff1a%s", deviceId, startTime, endTime));
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        this.cmder.recordInfoQuery(device, channelId, startTime, endTime);
        DeferredResult result = new DeferredResult(Long.valueOf(90000L));
        String uuid = UUID.randomUUID().toString();
        String key = "CALLBACK_RECORDINFO" + deviceId + channelId;
        this.resultHolder.put(key, uuid, result);
        result.onTimeout(() -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"timeout");
            this.resultHolder.invokeResult(msg);
        });
        return result;
    }
}

