/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.streamPush;

import com.genersoft.iot.vmp.gb28181.bean.GbStream;
import com.genersoft.iot.vmp.media.zlm.dto.StreamPushItem;
import com.genersoft.iot.vmp.service.IStreamPushService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u63a8\u6d41\u4fe1\u606f\u7ba1\u7406"})
@Controller
@CrossOrigin
@RequestMapping(value={"/api/push"})
public class StreamPushController {
    private static final Logger logger = LoggerFactory.getLogger(StreamPushController.class);
    @Autowired
    private IStreamPushService streamPushService;

    @ApiOperation(value="\u63a8\u6d41\u5217\u8868\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="count", value="\u6bcf\u9875\u67e5\u8be2\u6570\u91cf", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="query", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="online", value="\u662f\u5426\u5728\u7ebf", dataTypeClass=Boolean.class)})
    @GetMapping(value={"/list"})
    @ResponseBody
    public PageInfo<StreamPushItem> list(@RequestParam(required=false) Integer page, @RequestParam(required=false) Integer count, @RequestParam(required=false) String query, @RequestParam(required=false) Boolean online) {
        PageInfo pushList = this.streamPushService.getPushList(Integer.valueOf(page - 1), Integer.valueOf(page - 1 + count));
        return pushList;
    }

    @ApiOperation(value="\u5c06\u63a8\u6d41\u6dfb\u52a0\u5230\u56fd\u6807")
    @ApiImplicitParams(value={@ApiImplicitParam(name="stream", value="\u76f4\u64ad\u6d41\u5173\u8054\u56fd\u6807\u5e73\u53f0", dataTypeClass=GbStream.class)})
    @PostMapping(value={"/save_to_gb"})
    @ResponseBody
    public Object saveToGB(@RequestBody GbStream stream) {
        if (this.streamPushService.saveToGB(stream)) {
            return "success";
        }
        return "fail";
    }

    @ApiOperation(value="\u5c06\u63a8\u6d41\u79fb\u51fa\u5230\u56fd\u6807")
    @ApiImplicitParams(value={@ApiImplicitParam(name="stream", value="\u76f4\u64ad\u6d41\u5173\u8054\u56fd\u6807\u5e73\u53f0", dataTypeClass=GbStream.class)})
    @DeleteMapping(value={"/remove_form_gb"})
    @ResponseBody
    public Object removeFormGB(@RequestBody GbStream stream) {
        if (this.streamPushService.removeFromGB(stream)) {
            return "success";
        }
        return "fail";
    }
}

