/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.user;

import com.genersoft.iot.vmp.conf.security.SecurityUtils;
import com.genersoft.iot.vmp.conf.security.dto.LoginUser;
import com.genersoft.iot.vmp.service.IRoleService;
import com.genersoft.iot.vmp.service.IUserService;
import com.genersoft.iot.vmp.storager.dao.dto.Role;
import com.genersoft.iot.vmp.storager.dao.dto.User;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.security.sasl.AuthenticationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/user"})
public class UserController {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private IUserService userService;
    @Autowired
    private IRoleService roleService;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value="\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="username", required=true, value="\u7528\u6237\u540d", dataTypeClass=String.class), @ApiImplicitParam(name="password", required=true, value="\u5bc6\u7801\uff0832\u4f4dmd5\u52a0\u5bc6\uff09", dataTypeClass=String.class)})
    @GetMapping(value={"/login"})
    public WVPResult<LoginUser> login(@RequestParam String username, @RequestParam String password) {
        LoginUser user = null;
        WVPResult result = new WVPResult();
        try {
            user = SecurityUtils.login((String)username, (String)password, (AuthenticationManager)this.authenticationManager);
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
            result.setCode(-1);
            result.setMsg("fail");
        }
        if (user != null) {
            result.setCode(0);
            result.setMsg("success");
            result.setData((Object)user);
        } else {
            result.setCode(-1);
            result.setMsg("fail");
        }
        return result;
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="username", required=true, value="\u7528\u6237\u540d", dataTypeClass=String.class), @ApiImplicitParam(name="oldpassword", required=true, value="\u65e7\u5bc6\u7801\uff08\u5df2md5\u52a0\u5bc6\u7684\u5bc6\u7801\uff09", dataTypeClass=String.class), @ApiImplicitParam(name="password", required=true, value="\u65b0\u5bc6\u7801\uff08\u672amd5\u52a0\u5bc6\u7684\u5bc6\u7801\uff09", dataTypeClass=String.class)})
    @PostMapping(value={"/changePassword"})
    public String changePassword(@RequestParam String oldPassword, @RequestParam String password) {
        LoginUser userInfo = SecurityUtils.getUserInfo();
        if (userInfo == null) {
            return "fail";
        }
        String username = userInfo.getUsername();
        LoginUser user = null;
        try {
            int userId;
            boolean result;
            user = SecurityUtils.login((String)username, (String)oldPassword, (AuthenticationManager)this.authenticationManager);
            if (user != null && (result = this.userService.changePassword(userId = SecurityUtils.getUserId(), DigestUtils.md5DigestAsHex((byte[])password.getBytes())))) {
                return "success";
            }
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
        return "fail";
    }

    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="username", required=true, value="\u7528\u6237\u540d", dataTypeClass=String.class), @ApiImplicitParam(name="password", required=true, value="\u5bc6\u7801\uff08\u672amd5\u52a0\u5bc6\u7684\u5bc6\u7801\uff09", dataTypeClass=String.class), @ApiImplicitParam(name="roleId", required=true, value="\u89d2\u8272ID", dataTypeClass=String.class)})
    @PostMapping(value={"/add"})
    public ResponseEntity<WVPResult<Integer>> add(@RequestParam String username, @RequestParam String password, @RequestParam Integer roleId) {
        WVPResult result = new WVPResult();
        if (StringUtils.isEmpty((Object)username) || StringUtils.isEmpty((Object)password) || roleId == null) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        int currenRoleId = SecurityUtils.getUserInfo().getRole().getId();
        if (currenRoleId != 1) {
            result.setCode(-1);
            result.setMsg("\u7528\u6237\u65e0\u6743\u9650");
            return new ResponseEntity((Object)result, HttpStatus.FORBIDDEN);
        }
        User user = new User();
        user.setUsername(username);
        user.setPassword(DigestUtils.md5DigestAsHex((byte[])password.getBytes()));
        Role role = this.roleService.getRoleById(roleId.intValue());
        if (role == null) {
            result.setCode(-1);
            result.setMsg("roleId is not found");
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        user.setRole(role);
        user.setCreateTime(this.format.format(System.currentTimeMillis()));
        user.setUpdateTime(this.format.format(System.currentTimeMillis()));
        int addResult = this.userService.addUser(user);
        result.setCode(addResult > 0 ? 0 : -1);
        result.setMsg(addResult > 0 ? "success" : "fail");
        result.setData((Object)addResult);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, value="\u7528\u6237Id", dataTypeClass=Integer.class)})
    @DeleteMapping(value={"/delete"})
    public ResponseEntity<WVPResult<String>> delete(@RequestParam Integer id) {
        int currenRoleId = SecurityUtils.getUserInfo().getRole().getId();
        WVPResult result = new WVPResult();
        if (currenRoleId != 1) {
            result.setCode(-1);
            result.setMsg("\u7528\u6237\u65e0\u6743\u9650");
            return new ResponseEntity((Object)result, HttpStatus.FORBIDDEN);
        }
        int deleteResult = this.userService.deleteUser(id.intValue());
        result.setCode(deleteResult > 0 ? 0 : -1);
        result.setMsg(deleteResult > 0 ? "success" : "fail");
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237")
    @ApiImplicitParams(value={})
    @GetMapping(value={"/all"})
    public ResponseEntity<WVPResult<List<User>>> all() {
        List allUsers = this.userService.getAllUsers();
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        result.setData((Object)allUsers);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }
}

