/*
 * Decompiled with CFR 0.152.
 */
package top.panll.assist.config;

import java.io.File;
import java.io.IOException;
import net.bramp.ffmpeg.FFmpeg;
import net.bramp.ffmpeg.FFprobe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import top.panll.assist.dto.UserSettings;
import top.panll.assist.service.FFmpegExecUtils;
import top.panll.assist.service.VideoFileService;

@Component
@Order(value=1)
public class StartConfig
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(StartConfig.class);
    @Autowired
    private UserSettings userSettings;
    @Autowired
    private VideoFileService videoFileService;

    public void run(String ... args) {
        File recordFile;
        String record = this.userSettings.getRecord();
        if (!record.endsWith(File.separator)) {
            this.userSettings.setRecord(this.userSettings.getRecord() + File.separator);
        }
        if (!(recordFile = new File(record)).exists() || !recordFile.isDirectory()) {
            logger.error("[userSettings.record]\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u5b58\u5728");
            System.exit(1);
        }
        if (!recordFile.canRead()) {
            logger.error("[userSettings.record]\u8def\u5f84\u65e0\u6cd5\u8bfb\u53d6");
            System.exit(1);
        }
        if (!recordFile.canWrite()) {
            logger.error("[userSettings.record]\u8def\u5f84\u65e0\u6cd5\u5199\u5165");
            System.exit(1);
        }
        try {
            String ffmpegPath = this.userSettings.getFfmpeg();
            String ffprobePath = this.userSettings.getFfprobe();
            FFmpeg ffmpeg = new FFmpeg(ffmpegPath);
            FFprobe ffprobe = new FFprobe(ffprobePath);
            logger.info("wvp-pro\u8f85\u52a9\u7a0b\u5e8f\u542f\u52a8\u6210\u529f\u3002 \n{}\n{} ", (Object)ffmpeg.version(), (Object)ffprobe.version());
            FFmpegExecUtils.getInstance().ffmpeg = ffmpeg;
            FFmpegExecUtils.getInstance().ffprobe = ffprobe;
            File[] appFiles = recordFile.listFiles();
            if (appFiles != null && appFiles.length > 0) {
                for (File appFile : appFiles) {
                    File[] streamFiles = appFile.listFiles();
                    if (streamFiles == null || streamFiles.length <= 0) continue;
                    for (File streamFile : streamFiles) {
                        File[] dateFiles = streamFile.listFiles();
                        if (dateFiles == null || dateFiles.length <= 0) continue;
                        for (File dateFile : dateFiles) {
                            File[] files = dateFile.listFiles();
                            if (files == null || files.length <= 0) continue;
                            for (File file : files) {
                                this.videoFileService.handFile(file);
                            }
                        }
                    }
                }
            }
        }
        catch (IOException exception) {
            System.out.println(exception.getMessage());
            if (exception.getMessage().indexOf("ffmpeg") > 0) {
                logger.error("[userSettings.ffmpeg]\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5b89\u88c5ffmpeg\u5e76\u6b63\u786e\u914d\u7f6e");
                System.exit(1);
            }
            if (exception.getMessage().indexOf("ffprobe") > 0) {
                logger.error("[userSettings.ffprobe]\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5b89\u88c5ffprobe\u5e76\u6b63\u786e\u914d\u7f6e");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error("\u73af\u5883\u9519\u8bef\uff1a " + exception.getMessage());
        }
    }
}

