/*
 * Decompiled with CFR 0.152.
 */
package top.panll.assist.config;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import top.panll.assist.service.VideoFileService;

@Component
@EnableScheduling
public class TaskConfig {
    private static final Logger logger = LoggerFactory.getLogger(TaskConfig.class);
    @Autowired
    private VideoFileService videoFileService;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @Scheduled(cron="0 0 0 * * ?")
    private void configureTasks() {
        logger.info("\u5f55\u50cf\u8fc7\u671f\u81ea\u68c0\u4efb\u52a1\u6267\u884c");
        List appList = this.videoFileService.getAppList();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        Date monday = calendar.getTime();
        if (appList != null && appList.size() > 0) {
            for (File appFile : appList) {
                List streamList = this.videoFileService.getStreamList(appFile.getName());
                if (streamList != null && streamList.size() > 0) {
                    for (File streamFile : streamList) {
                        File[] recordDateFileList = streamFile.listFiles();
                        if (recordDateFileList != null && recordDateFileList.length > 0) {
                            for (File recordDateFile : recordDateFileList) {
                                try {
                                    Date fileDaye = this.simpleDateFormat.parse(recordDateFile.getName());
                                    if (!fileDaye.before(monday)) continue;
                                    logger.debug("\u79fb\u9664\u6587\u4ef6[{}]", (Object)recordDateFile.getAbsolutePath());
                                    recordDateFile.delete();
                                }
                                catch (ParseException e) {
                                    logger.error("\u65e0\u6cd5\u683c\u5f0f\u5316[{}]\u4e3a\u65e5\u671f, \u76f4\u63a5\u79fb\u9664", (Object)recordDateFile.getName());
                                    recordDateFile.delete();
                                }
                            }
                        }
                        if (streamFile.listFiles().length != 0) continue;
                        streamFile.delete();
                    }
                }
                if (appFile.listFiles().length != 0) continue;
                appFile.delete();
            }
        }
    }
}

