/*
 * Decompiled with CFR 0.152.
 */
package top.panll.assist.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import top.panll.assist.controller.bean.WVPResult;
import top.panll.assist.dto.MergeOrCutTaskInfo;
import top.panll.assist.dto.SpaceInfo;
import top.panll.assist.service.VideoFileService;
import top.panll.assist.utils.PageInfo;

@CrossOrigin
@RestController
@RequestMapping(value={"/api/record"})
public class RecordController {
    private static final Logger logger = LoggerFactory.getLogger(RecordController.class);
    @Autowired
    private VideoFileService videoFileService;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @GetMapping(value={"/list"})
    @ResponseBody
    public WVPResult<PageInfo<Map<String, String>>> getList(@RequestParam int page, @RequestParam int count) {
        WVPResult result = new WVPResult();
        List appList = this.videoFileService.getList();
        result.setCode(0);
        result.setMsg("success");
        PageInfo stringPageInfo = new PageInfo(appList);
        stringPageInfo.startPage(page, count);
        result.setData((Object)stringPageInfo);
        return result;
    }

    @GetMapping(value={"/app/list"})
    @ResponseBody
    public WVPResult<PageInfo<String>> getAppList(@RequestParam int page, @RequestParam int count) {
        WVPResult result = new WVPResult();
        ArrayList<String> resultData = new ArrayList<String>();
        List appList = this.videoFileService.getAppList();
        for (File file : appList) {
            resultData.add(file.getName());
        }
        result.setCode(0);
        result.setMsg("success");
        PageInfo stringPageInfo = new PageInfo(resultData);
        stringPageInfo.startPage(page, count);
        result.setData((Object)stringPageInfo);
        return result;
    }

    @GetMapping(value={"/stream/list"})
    @ResponseBody
    public WVPResult<PageInfo<String>> getStreamList(@RequestParam int page, @RequestParam int count, @RequestParam String app) {
        WVPResult result = new WVPResult();
        ArrayList<String> resultData = new ArrayList<String>();
        if (app == null) {
            result.setCode(400);
            result.setMsg("app\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        List streamList = this.videoFileService.getStreamList(app);
        for (File file : streamList) {
            resultData.add(file.getName());
        }
        result.setCode(0);
        result.setMsg("success");
        PageInfo stringPageInfo = new PageInfo(resultData);
        stringPageInfo.startPage(page, count);
        result.setData((Object)stringPageInfo);
        return result;
    }

    @GetMapping(value={"/date/list"})
    @ResponseBody
    public WVPResult<List<String>> getDateList(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month, @RequestParam String app, @RequestParam String stream) {
        WVPResult result = new WVPResult();
        ArrayList<String> resultData = new ArrayList<String>();
        if (app == null) {
            result.setCode(400);
            result.setMsg("app\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        if (stream == null) {
            result.setCode(400);
            result.setMsg("stream\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        List dateList = this.videoFileService.getDateList(app, stream, year, month);
        for (File file : dateList) {
            resultData.add(file.getName());
        }
        result.setCode(0);
        result.setMsg("success");
        result.setData(resultData);
        return result;
    }

    @GetMapping(value={"/file/list"})
    @ResponseBody
    public WVPResult<PageInfo<String>> getRecordList(@RequestParam int page, @RequestParam int count, @RequestParam String app, @RequestParam String stream, @RequestParam String startTime, @RequestParam String endTime) {
        WVPResult result = new WVPResult();
        ArrayList<String> recordList = new ArrayList<String>();
        try {
            List filesInTime;
            Date startTimeDate = null;
            Date endTimeDate = null;
            if (startTime != null) {
                startTimeDate = this.formatter.parse(startTime);
            }
            if (endTime != null) {
                endTimeDate = this.formatter.parse(endTime);
            }
            if ((filesInTime = this.videoFileService.getFilesInTime(app, stream, startTimeDate, endTimeDate)) != null && filesInTime.size() > 0) {
                for (File file : filesInTime) {
                    recordList.add(file.getName());
                }
            }
            result.setCode(0);
            result.setMsg("success");
            PageInfo stringPageInfo = new PageInfo(recordList);
            stringPageInfo.startPage(page, count);
            result.setData((Object)stringPageInfo);
        }
        catch (ParseException e) {
            logger.error("\u9519\u8bef\u7684\u5f00\u59cb\u65f6\u95f4[{}]\u6216\u7ed3\u675f\u65f6\u95f4[{}]", (Object)startTime, (Object)endTime);
            result.setCode(400);
            result.setMsg("\u9519\u8bef\u7684\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4");
        }
        return result;
    }

    @GetMapping(value={"/file/download/task/add"})
    @ResponseBody
    public WVPResult<String> addTaskForDownload(@RequestParam String app, @RequestParam String stream, @RequestParam String startTime, @RequestParam String endTime) {
        WVPResult result = new WVPResult();
        Date startTimeDate = null;
        Date endTimeDate = null;
        try {
            if (startTime != null) {
                startTimeDate = this.formatter.parse(startTime);
            }
            if (endTime != null) {
                endTimeDate = this.formatter.parse(endTime);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String id = this.videoFileService.mergeOrCut(app, stream, startTimeDate, endTimeDate);
        result.setCode(0);
        result.setMsg(id != null ? "success" : "error\uff1a \u53ef\u80fd\u672a\u627e\u5230\u89c6\u9891\u6587\u4ef6");
        result.setData((Object)id);
        return result;
    }

    @GetMapping(value={"/file/download/task/list"})
    @ResponseBody
    public WVPResult<List<MergeOrCutTaskInfo>> getTaskListForDownload(@RequestParam Boolean isEnd) {
        if (isEnd == null) {
            isEnd = false;
        }
        List taskList = this.videoFileService.getTaskListForDownload(isEnd.booleanValue());
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg(taskList != null ? "success" : "error");
        result.setData((Object)taskList);
        return result;
    }

    @GetMapping(value={"/file/download/task/stop"})
    @ResponseBody
    public WVPResult<String> stopTaskForDownload(@RequestParam String taskId) {
        return null;
    }

    @ResponseBody
    @PostMapping(value={"/on_record_mp4"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> onRecordMp4(@RequestBody JSONObject json) {
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("msg", (Object)"success");
        String file_path = json.getString("file_path");
        logger.debug("ZLM \u5f55\u5236\u5b8c\u6210\uff0c\u53c2\u6570\uff1a" + file_path);
        if (file_path == null) {
            return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
        }
        this.videoFileService.handFile(new File(file_path));
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }

    @ResponseBody
    @GetMapping(value={"/space"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> getSpace() {
        JSONObject ret = new JSONObject();
        ret.put("code", (Object)0);
        ret.put("msg", (Object)"success");
        SpaceInfo spaceInfo = this.videoFileService.getSpaceInfo();
        ret.put("data", JSON.toJSON((Object)spaceInfo));
        return new ResponseEntity((Object)ret.toString(), HttpStatus.OK);
    }
}

