/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.conf;

import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import java.text.SimpleDateFormat;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(value="mediaConfig")
public class MediaConfig {
    @Value(value="${media.id:}")
    private String id;
    @Value(value="${media.ip}")
    private String ip;
    @Value(value="${media.hook-ip:${sip.ip}}")
    private String hookIp;
    @Value(value="${sip.ip}")
    private String sipIp;
    @Value(value="${sip.domain}")
    private String sipDomain;
    @Value(value="${media.sdp-ip:${media.ip}}")
    private String sdpIp;
    @Value(value="${media.stream-ip:${media.ip}}")
    private String streamIp;
    @Value(value="${media.http-port}")
    private Integer httpPort;
    @Value(value="${media.http-ssl-port:0}")
    private Integer httpSSlPort = 0;
    @Value(value="${media.rtmp-port:0}")
    private Integer rtmpPort = 0;
    @Value(value="${media.rtmp-ssl-port:0}")
    private Integer rtmpSSlPort = 0;
    @Value(value="${media.rtp-proxy-port:0}")
    private Integer rtpProxyPort = 0;
    @Value(value="${media.rtsp-port:0}")
    private Integer rtspPort = 0;
    @Value(value="${media.rtsp-ssl-port:0}")
    private Integer rtspSSLPort = 0;
    @Value(value="${media.auto-config:true}")
    private boolean autoConfig = true;
    @Value(value="${media.secret}")
    private String secret;
    @Value(value="${media.stream-none-reader-delay-ms:18000}")
    private String streamNoneReaderDelayMS = "18000";
    @Value(value="${media.rtp.enable}")
    private boolean rtpEnable;
    @Value(value="${media.rtp.port-range}")
    private String rtpPortRange;
    @Value(value="${media.rtp.send-port-range}")
    private String sendRtpPortRange;
    @Value(value="${media.record-assist-port:0}")
    private Integer recordAssistPort = 0;

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public String getHookIp() {
        if (StringUtils.isEmpty((Object)this.hookIp)) {
            return this.sipIp;
        }
        return this.hookIp;
    }

    public String getSipIp() {
        if (this.sipIp == null) {
            return this.ip;
        }
        return this.sipIp;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpSSlPort() {
        return this.httpSSlPort;
    }

    public int getRtmpPort() {
        return this.rtmpPort;
    }

    public int getRtmpSSlPort() {
        return this.rtmpSSlPort;
    }

    public int getRtpProxyPort() {
        if (this.rtpProxyPort == null) {
            return 0;
        }
        return this.rtpProxyPort;
    }

    public int getRtspPort() {
        return this.rtspPort;
    }

    public int getRtspSSLPort() {
        return this.rtspSSLPort;
    }

    public boolean isAutoConfig() {
        return this.autoConfig;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getStreamNoneReaderDelayMS() {
        return this.streamNoneReaderDelayMS;
    }

    public boolean isRtpEnable() {
        return this.rtpEnable;
    }

    public String getRtpPortRange() {
        return this.rtpPortRange;
    }

    public int getRecordAssistPort() {
        return this.recordAssistPort;
    }

    public String getSdpIp() {
        if (StringUtils.isEmpty((Object)this.sdpIp)) {
            return this.ip;
        }
        return this.sdpIp;
    }

    public String getStreamIp() {
        if (StringUtils.isEmpty((Object)this.streamIp)) {
            return this.ip;
        }
        return this.streamIp;
    }

    public String getSipDomain() {
        return this.sipDomain;
    }

    public String getSendRtpPortRange() {
        return this.sendRtpPortRange;
    }

    public MediaServerItem getMediaSerItem() {
        MediaServerItem mediaServerItem = new MediaServerItem();
        mediaServerItem.setId(this.id);
        mediaServerItem.setIp(this.ip);
        mediaServerItem.setDefaultServer(true);
        mediaServerItem.setHookIp(this.getHookIp());
        mediaServerItem.setSdpIp(this.getSdpIp());
        mediaServerItem.setStreamIp(this.getStreamIp());
        mediaServerItem.setHttpPort(this.httpPort.intValue());
        mediaServerItem.setHttpSSlPort(this.httpSSlPort.intValue());
        mediaServerItem.setRtmpPort(this.rtmpPort.intValue());
        mediaServerItem.setRtmpSSlPort(this.rtmpSSlPort.intValue());
        mediaServerItem.setRtpProxyPort(this.getRtpProxyPort());
        mediaServerItem.setRtspPort(this.rtspPort.intValue());
        mediaServerItem.setRtspSSLPort(this.rtspSSLPort.intValue());
        mediaServerItem.setAutoConfig(this.autoConfig);
        mediaServerItem.setSecret(this.secret);
        mediaServerItem.setStreamNoneReaderDelayMS(this.streamNoneReaderDelayMS);
        mediaServerItem.setRtpEnable(this.rtpEnable);
        mediaServerItem.setRtpPortRange(this.rtpPortRange);
        mediaServerItem.setSendRtpPortRange(this.sendRtpPortRange);
        mediaServerItem.setRecordAssistPort(this.recordAssistPort.intValue());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mediaServerItem.setCreateTime(format.format(System.currentTimeMillis()));
        mediaServerItem.setUpdateTime(format.format(System.currentTimeMillis()));
        return mediaServerItem;
    }
}

