/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.conf.security;

import com.genersoft.iot.vmp.conf.security.SecurityUtils;
import com.genersoft.iot.vmp.conf.security.dto.LoginUser;
import com.genersoft.iot.vmp.service.IUserService;
import com.genersoft.iot.vmp.storager.dao.dto.User;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class DefaultUserDetailsServiceImpl
implements UserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUserDetailsServiceImpl.class);
    @Autowired
    private IUserService userService;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        if (StrUtil.isBlank((CharSequence)username)) {
            logger.info("\u767b\u5f55\u7528\u6237\uff1a{} \u4e0d\u5b58\u5728", (Object)username);
            throw new UsernameNotFoundException("\u767b\u5f55\u7528\u6237\uff1a" + username + " \u4e0d\u5b58\u5728");
        }
        User user = this.userService.getUserByUsername(username);
        if (user == null) {
            logger.info("\u767b\u5f55\u7528\u6237\uff1a{} \u4e0d\u5b58\u5728", (Object)username);
            throw new UsernameNotFoundException("\u767b\u5f55\u7528\u6237\uff1a" + username + " \u4e0d\u5b58\u5728");
        }
        String password = SecurityUtils.encryptPassword((String)user.getPassword());
        user.setPassword(password);
        return new LoginUser(user, LocalDateTime.now());
    }
}

