/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181;

import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.transmit.ISIPProcessorObserver;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import java.util.Properties;
import java.util.TooManyListenersException;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipStack;
import javax.sip.TransportNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
public class SipLayer {
    private static final Logger logger = LoggerFactory.getLogger(SipLayer.class);
    @Autowired
    private SipConfig sipConfig;
    @Autowired
    private ISIPProcessorObserver sipProcessorObserver;
    private SipStackImpl sipStack;
    private SipFactory sipFactory;

    @Bean(value={"sipFactory"})
    private SipFactory createSipFactory() {
        this.sipFactory = SipFactory.getInstance();
        this.sipFactory.setPathName("gov.nist");
        return this.sipFactory;
    }

    @Bean(value={"sipStack"})
    @DependsOn(value={"sipFactory"})
    private SipStack createSipStack() throws PeerUnavailableException {
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", "GB28181_SIP");
        properties.setProperty("javax.sip.IP_ADDRESS", this.sipConfig.getMonitorIp());
        properties.setProperty("gov.nist.javax.sip.LOG_MESSAGE_CONTENT", "false");
        properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "0");
        properties.setProperty("gov.nist.javax.sip.SERVER_LOG", "sip_server_log");
        properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", "sip_debug_log");
        this.sipStack = (SipStackImpl)this.sipFactory.createSipStack(properties);
        return this.sipStack;
    }

    @Bean(name={"tcpSipProvider"})
    @DependsOn(value={"sipStack"})
    private SipProviderImpl startTcpListener() {
        ListeningPoint tcpListeningPoint = null;
        SipProviderImpl tcpSipProvider = null;
        try {
            tcpListeningPoint = this.sipStack.createListeningPoint(this.sipConfig.getMonitorIp(), this.sipConfig.getPort().intValue(), "TCP");
            tcpSipProvider = (SipProviderImpl)this.sipStack.createSipProvider(tcpListeningPoint);
            tcpSipProvider.addSipListener((SipListener)this.sipProcessorObserver);
            logger.info("Sip Server TCP \u542f\u52a8\u6210\u529f port {" + this.sipConfig.getMonitorIp() + ":" + this.sipConfig.getPort() + "}");
        }
        catch (TransportNotSupportedException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            logger.error("\u65e0\u6cd5\u4f7f\u7528 [ {}:{} ]\u4f5c\u4e3aSIP[ TCP ]\u670d\u52a1\uff0c\u53ef\u6392\u67e5: 1. sip.monitor-ip \u662f\u5426\u4e3a\u672c\u673a\u7f51\u5361IP; 2. sip.port \u662f\u5426\u5df2\u88ab\u5360\u7528", (Object)this.sipConfig.getMonitorIp(), (Object)this.sipConfig.getPort());
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        catch (ObjectInUseException e) {
            e.printStackTrace();
        }
        return tcpSipProvider;
    }

    @Bean(name={"udpSipProvider"})
    @DependsOn(value={"sipStack"})
    private SipProviderImpl startUdpListener() {
        ListeningPoint udpListeningPoint = null;
        SipProviderImpl udpSipProvider = null;
        try {
            udpListeningPoint = this.sipStack.createListeningPoint(this.sipConfig.getMonitorIp(), this.sipConfig.getPort().intValue(), "UDP");
            udpSipProvider = (SipProviderImpl)this.sipStack.createSipProvider(udpListeningPoint);
            udpSipProvider.addSipListener((SipListener)this.sipProcessorObserver);
        }
        catch (TransportNotSupportedException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            logger.error("\u65e0\u6cd5\u4f7f\u7528 [ {}:{} ]\u4f5c\u4e3aSIP[ UDP ]\u670d\u52a1\uff0c\u53ef\u6392\u67e5: 1. sip.monitor-ip \u662f\u5426\u4e3a\u672c\u673a\u7f51\u5361IP; 2. sip.port \u662f\u5426\u5df2\u88ab\u5360\u7528", (Object)this.sipConfig.getMonitorIp(), (Object)this.sipConfig.getPort());
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        catch (ObjectInUseException e) {
            e.printStackTrace();
        }
        logger.info("Sip Server UDP \u542f\u52a8\u6210\u529f port [" + this.sipConfig.getMonitorIp() + ":" + this.sipConfig.getPort() + "]");
        return udpSipProvider;
    }
}

