/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.event;

import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceAlarm;
import com.genersoft.iot.vmp.gb28181.event.alarm.AlarmEvent;
import com.genersoft.iot.vmp.gb28181.event.offline.OfflineEvent;
import com.genersoft.iot.vmp.gb28181.event.online.OnlineEvent;
import com.genersoft.iot.vmp.gb28181.event.platformKeepaliveExpire.PlatformKeepaliveExpireEvent;
import com.genersoft.iot.vmp.gb28181.event.platformNotRegister.PlatformNotRegisterEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class EventPublisher {
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public void onlineEventPublish(Device device, String from) {
        OnlineEvent onEvent = new OnlineEvent((Object)this);
        onEvent.setDevice(device);
        onEvent.setFrom(from);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)onEvent);
    }

    public void outlineEventPublish(String deviceId, String from) {
        OfflineEvent outEvent = new OfflineEvent((Object)this);
        outEvent.setDeviceId(deviceId);
        outEvent.setFrom(from);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)outEvent);
    }

    public void platformKeepaliveExpireEventPublish(String platformGbId) {
        PlatformKeepaliveExpireEvent platformNotRegisterEvent = new PlatformKeepaliveExpireEvent((Object)this);
        platformNotRegisterEvent.setPlatformGbID(platformGbId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)platformNotRegisterEvent);
    }

    public void platformNotRegisterEventPublish(String platformGbId) {
        PlatformNotRegisterEvent platformNotRegisterEvent = new PlatformNotRegisterEvent((Object)this);
        platformNotRegisterEvent.setPlatformGbID(platformGbId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)platformNotRegisterEvent);
    }

    public void deviceAlarmEventPublish(DeviceAlarm deviceAlarm) {
        AlarmEvent alarmEvent = new AlarmEvent((Object)this);
        alarmEvent.setAlarmInfo(deviceAlarm);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)alarmEvent);
    }
}

