/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.event.offline;

import com.genersoft.iot.vmp.gb28181.event.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
public class KeepaliveTimeoutListenerForPlatform
extends KeyExpirationEventMessageListener {
    private Logger logger = LoggerFactory.getLogger(KeepaliveTimeoutListenerForPlatform.class);
    @Autowired
    private EventPublisher publisher;

    public KeepaliveTimeoutListenerForPlatform(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    public void onMessage(Message message, byte[] pattern) {
        String expiredKey = message.toString();
        this.logger.debug(expiredKey);
        if (expiredKey.startsWith("VMP_PLATFORM_KEEPLIVE_")) {
            String platformGBId = expiredKey.substring("VMP_PLATFORM_KEEPLIVE_".length(), expiredKey.length());
            this.publisher.platformKeepaliveExpireEventPublish(platformGBId);
        } else if (expiredKey.startsWith("VMP_PLATFORM_REGISTER_")) {
            String platformGBId = expiredKey.substring("VMP_PLATFORM_REGISTER_".length(), expiredKey.length());
            this.publisher.platformNotRegisterEventPublish(platformGBId);
        } else {
            String deviceId = expiredKey.substring("VMP_keeplive_".length(), expiredKey.length());
            this.publisher.outlineEventPublish(deviceId, "2");
        }
    }
}

