/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.event.platformKeepaliveExpire;

import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatformCatch;
import com.genersoft.iot.vmp.gb28181.event.EventPublisher;
import com.genersoft.iot.vmp.gb28181.event.SipSubscribe;
import com.genersoft.iot.vmp.gb28181.event.platformKeepaliveExpire.PlatformKeepaliveExpireEvent;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.ISIPCommanderForPlatform;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PlatformKeepaliveExpireEventLister
implements ApplicationListener<PlatformKeepaliveExpireEvent> {
    private static final Logger logger = LoggerFactory.getLogger(PlatformKeepaliveExpireEventLister.class);
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private ISIPCommanderForPlatform sipCommanderForPlatform;
    @Autowired
    private SipSubscribe sipSubscribe;
    @Autowired
    private EventPublisher publisher;

    public void onApplicationEvent(@NotNull PlatformKeepaliveExpireEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5e73\u53f0\u5fc3\u8df3\u5230\u671f\u4e8b\u4ef6\u4e8b\u4ef6\u89e6\u53d1\uff0c\u5e73\u53f0\u56fd\u6807ID\uff1a" + event.getPlatformGbID());
        }
        ParentPlatform parentPlatform = this.storager.queryParentPlatByServerGBId(event.getPlatformGbID());
        ParentPlatformCatch parentPlatformCatch = this.redisCatchStorage.queryPlatformCatchInfo(event.getPlatformGbID());
        if (parentPlatformCatch == null) {
            return;
        }
        if (parentPlatform == null) {
            logger.debug("\u5e73\u53f0\u5fc3\u8df3\u5230\u671f\u4e8b\u4ef6\u4e8b\u4ef6\u89e6\u53d1\uff0c\u4f46\u5e73\u53f0\u5df2\u7ecf\u5220\u9664!!! \u5e73\u53f0\u56fd\u6807ID\uff1a" + event.getPlatformGbID());
            return;
        }
        parentPlatformCatch.setParentPlatform(parentPlatform);
        if (parentPlatformCatch.getKeepAliveReply() >= 3) {
            logger.warn("\u67093\u6b21\u672a\u6536\u5230\u5fc3\u8df3\u56de\u590d,\u6807\u8bb0\u8bbe\u7f6e\u5e73\u53f0\u72b6\u6001\u4e3a\u79bb\u7ebf, \u5e76\u91cd\u65b0\u6ce8\u518c \u5e73\u53f0\u56fd\u6807ID\uff1a" + event.getPlatformGbID());
            this.storager.updateParentPlatformStatus(event.getPlatformGbID(), false);
            this.publisher.platformNotRegisterEventPublish(event.getPlatformGbID());
            parentPlatformCatch.setKeepAliveReply(0);
            this.redisCatchStorage.updatePlatformCatchInfo(parentPlatformCatch);
        } else {
            String callId = this.sipCommanderForPlatform.keepalive(parentPlatform);
            parentPlatformCatch.setKeepAliveReply(parentPlatformCatch.getKeepAliveReply() + 1);
            this.redisCatchStorage.updatePlatformKeepalive(parentPlatform);
            this.redisCatchStorage.updatePlatformCatchInfo(parentPlatformCatch);
            this.sipSubscribe.addOkSubscribe(callId, eventResult -> {
                if (eventResult.statusCode == 200) {
                    parentPlatformCatch.setKeepAliveReply(0);
                    this.redisCatchStorage.updatePlatformCatchInfo(parentPlatformCatch);
                }
            });
        }
    }
}

