/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.session;

import com.genersoft.iot.vmp.utils.ConfigConst;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class SsrcConfig {
    private String mediaServerId;
    private String ssrcPrefix;
    private List<String> isUsed;
    private List<String> notUsed;

    public SsrcConfig() {
    }

    public SsrcConfig(String mediaServerId, Set<String> usedSet, String sipDomain) {
        this.mediaServerId = mediaServerId;
        this.isUsed = new ArrayList();
        this.ssrcPrefix = sipDomain.substring(3, 8);
        this.notUsed = new ArrayList();
        for (int i = 1; i < ConfigConst.MAX_STRTEAM_COUNT; ++i) {
            String ssrc = i < 10 ? "000" + i : (i < 100 ? "00" + i : (i < 1000 ? "0" + i : String.valueOf(i)));
            if (null == usedSet || !usedSet.contains(ssrc)) {
                this.notUsed.add(ssrc);
                continue;
            }
            this.isUsed.add(ssrc);
        }
    }

    public String getPlaySsrc() {
        return "0" + this.getSsrcPrefix() + this.getSN();
    }

    public String getPlayBackSsrc() {
        return "1" + this.getSsrcPrefix() + this.getSN();
    }

    public void releaseSsrc(String ssrc) {
        if (ssrc == null) {
            return;
        }
        String sn = ssrc.substring(6);
        try {
            this.isUsed.remove(sn);
            this.notUsed.add(sn);
        }
        catch (NullPointerException e) {
            System.out.printf("11111", new Object[0]);
        }
    }

    private String getSN() {
        String sn = null;
        int index = 0;
        if (this.notUsed.size() == 0) {
            throw new RuntimeException("ssrc\u5df2\u7ecf\u7528\u5b8c");
        }
        if (this.notUsed.size() == 1) {
            sn = (String)this.notUsed.get(0);
        } else {
            index = new Random().nextInt(this.notUsed.size() - 1);
            sn = (String)this.notUsed.get(index);
        }
        this.notUsed.remove(index);
        this.isUsed.add(sn);
        return sn;
    }

    public String getSsrcPrefix() {
        return this.ssrcPrefix;
    }

    public String getMediaServerId() {
        return this.mediaServerId;
    }

    public void setMediaServerId(String mediaServerId) {
        this.mediaServerId = mediaServerId;
    }

    public void setSsrcPrefix(String ssrcPrefix) {
        this.ssrcPrefix = ssrcPrefix;
    }

    public List<String> getIsUsed() {
        return this.isUsed;
    }

    public void setIsUsed(List<String> isUsed) {
        this.isUsed = isUsed;
    }

    public List<String> getNotUsed() {
        return this.notUsed;
    }

    public void setNotUsed(List<String> notUsed) {
        this.notUsed = notUsed;
    }
}

