/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.callback;

import com.genersoft.iot.vmp.gb28181.bean.RecordInfo;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.cmd.RecordInfoResponseMessageHandler;
import com.genersoft.iot.vmp.utils.redis.RedisUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class CheckForAllRecordsThread
extends Thread {
    private String key;
    private RecordInfo recordInfo;
    private RedisUtil redis;
    private Logger logger;
    private DeferredResultHolder deferredResultHolder;

    public CheckForAllRecordsThread(String key, RecordInfo recordInfo) {
        this.key = key;
        this.recordInfo = recordInfo;
    }

    @Override
    public void run() {
        String cacheKey = this.key;
        long stop = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
        while (stop > System.nanoTime()) {
            int i;
            List cacheKeys = this.redis.scan(cacheKey + "_*");
            ArrayList totalRecordList = new ArrayList();
            for (i = 0; i < cacheKeys.size(); ++i) {
                totalRecordList.addAll((List)this.redis.get(cacheKeys.get(i).toString()));
            }
            if (totalRecordList.size() < this.recordInfo.getSumNum()) {
                this.logger.info("\u5df2\u83b7\u53d6" + totalRecordList.size() + "\u9879\u5f55\u50cf\u6570\u636e\uff0c\u5171" + this.recordInfo.getSumNum() + "\u9879");
                continue;
            }
            this.logger.info("\u5f55\u50cf\u6570\u636e\u5df2\u5168\u90e8\u83b7\u53d6\uff0c\u5171 {} \u9879", (Object)this.recordInfo.getSumNum());
            this.recordInfo.setRecordList(totalRecordList);
            for (i = 0; i < cacheKeys.size(); ++i) {
                this.redis.del(new String[]{cacheKeys.get(i).toString()});
            }
        }
        this.recordInfo.getRecordList().sort(Comparator.naturalOrder());
        RequestMessage msg = new RequestMessage();
        msg.setKey("CALLBACK_RECORDINFO" + this.recordInfo.getDeviceId() + this.recordInfo.getChannelId());
        msg.setData((Object)this.recordInfo);
        this.deferredResultHolder.invokeAllResult(msg);
        this.logger.info("\u5904\u7406\u5b8c\u6210\uff0c\u8fd4\u56de\u7ed3\u679c");
        RecordInfoResponseMessageHandler.threadNameList.remove(cacheKey);
    }

    public void setRedis(RedisUtil redis) {
        this.redis = redis;
    }

    public void setDeferredResultHolder(DeferredResultHolder deferredResultHolder) {
        this.deferredResultHolder = deferredResultHolder;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

