/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl;

import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.auth.DigestServerAuthenticationHelper;
import com.genersoft.iot.vmp.gb28181.auth.RegisterLogicHandler;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.WvpSipDate;
import com.genersoft.iot.vmp.gb28181.event.EventPublisher;
import com.genersoft.iot.vmp.gb28181.transmit.SIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.ISIPRequestProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import gov.nist.javax.sip.RequestEventExt;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.SIPDate;
import gov.nist.javax.sip.header.SIPDateHeader;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Locale;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RegisterRequestProcessor
extends SIPRequestProcessorParent
implements InitializingBean,
ISIPRequestProcessor {
    private Logger logger = LoggerFactory.getLogger(RegisterRequestProcessor.class);
    public String method = "REGISTER";
    @Autowired
    private SipConfig sipConfig;
    @Autowired
    private RegisterLogicHandler handler;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private EventPublisher publisher;
    @Autowired
    private SIPProcessorObserver sipProcessorObserver;

    public void afterPropertiesSet() throws Exception {
        this.sipProcessorObserver.addRequestProcessor(this.method, (ISIPRequestProcessor)this);
    }

    public void process(RequestEvent evt) {
        try {
            RequestEventExt evtExt = (RequestEventExt)evt;
            String requestAddress = evtExt.getRemoteIpAddress() + ":" + evtExt.getRemotePort();
            this.logger.info("[{}] \u6536\u5230\u6ce8\u518c\u8bf7\u6c42\uff0c\u5f00\u59cb\u5904\u7406", (Object)requestAddress);
            Request request = evt.getRequest();
            Response response = null;
            boolean passwordCorrect = false;
            int registerFlag = 0;
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            AddressImpl address = (AddressImpl)fromHeader.getAddress();
            SipUri uri = (SipUri)address.getURI();
            String deviceId = uri.getUser();
            Device device = this.storager.queryVideoDevice(deviceId);
            AuthorizationHeader authorhead = (AuthorizationHeader)request.getHeader("Authorization");
            if (authorhead != null) {
                passwordCorrect = new DigestServerAuthenticationHelper().doAuthenticatePlainTextPassword(request, this.sipConfig.getPassword());
            }
            if (StringUtils.isEmpty((Object)this.sipConfig.getPassword())) {
                passwordCorrect = true;
            }
            if (authorhead == null) {
                this.logger.info("[{}] \u672a\u643a\u5e26\u6388\u6743\u5934 \u56de\u590d401", (Object)requestAddress);
                response = this.getMessageFactory().createResponse(401, request);
                new DigestServerAuthenticationHelper().generateChallenge(this.getHeaderFactory(), response, this.sipConfig.getDomain());
            } else if (!passwordCorrect) {
                response = this.getMessageFactory().createResponse(403, request);
                response.setReasonPhrase("wrong password");
                this.logger.info("[{}] \u5bc6\u7801/SIP\u670d\u52a1\u5668ID\u9519\u8bef, \u56de\u590d403", (Object)requestAddress);
            } else {
                response = this.getMessageFactory().createResponse(200, request);
                SIPDateHeader dateHeader = new SIPDateHeader();
                WvpSipDate wvpSipDate = new WvpSipDate(Calendar.getInstance(Locale.ENGLISH).getTimeInMillis());
                dateHeader.setDate((SIPDate)wvpSipDate);
                response.addHeader((Header)dateHeader);
                ExpiresHeader expiresHeader = (ExpiresHeader)request.getHeader("Expires");
                if (expiresHeader == null) {
                    response = this.getMessageFactory().createResponse(400, request);
                    ServerTransaction serverTransaction = this.getServerTransaction(evt);
                    serverTransaction.sendResponse(response);
                    if (serverTransaction.getDialog() != null) {
                        serverTransaction.getDialog().delete();
                    }
                    return;
                }
                response.addHeader(request.getHeader("Contact"));
                response.addHeader((Header)request.getExpires());
                ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
                String received = viaHeader.getReceived();
                int rPort = viaHeader.getRPort();
                if (StringUtils.isEmpty((Object)received) || rPort == -1) {
                    received = viaHeader.getHost();
                    rPort = viaHeader.getPort();
                }
                if (device == null) {
                    device = new Device();
                    device.setStreamMode("UDP");
                    device.setCharset("gb2312");
                    device.setDeviceId(deviceId);
                    device.setFirsRegister(true);
                }
                device.setIp(received);
                device.setPort(rPort);
                device.setHostAddress(received.concat(":").concat(String.valueOf(rPort)));
                if (expiresHeader.getExpires() == 0) {
                    registerFlag = 2;
                } else {
                    device.setExpires(expiresHeader.getExpires());
                    registerFlag = 1;
                    boolean isTcp = false;
                    ViaHeader reqViaHeader = (ViaHeader)request.getHeader("Via");
                    String transport = reqViaHeader.getTransport();
                    if (transport.equals("TCP")) {
                        isTcp = true;
                    }
                    device.setTransport(isTcp ? "TCP" : "UDP");
                }
            }
            ServerTransaction serverTransaction = this.getServerTransaction(evt);
            serverTransaction.sendResponse(response);
            if (serverTransaction.getDialog() != null) {
                serverTransaction.getDialog().delete();
            }
            if (registerFlag == 1) {
                this.logger.info("[{}] \u6ce8\u518c\u6210\u529f! deviceId:" + device.getDeviceId(), (Object)requestAddress);
                this.publisher.onlineEventPublish(device, "1");
                this.handler.onRegister(device);
            } else if (registerFlag == 2) {
                this.logger.info("[{}] \u6ce8\u9500\u6210\u529f! deviceId:" + device.getDeviceId(), (Object)requestAddress);
                this.publisher.outlineEventPublish(device.getDeviceId(), "1");
            }
        }
        catch (NoSuchAlgorithmException | ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
        }
    }
}

