/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.control.cmd;

import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommanderFroPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.control.ControlMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import javax.sip.RequestEvent;
import javax.sip.address.SipURI;
import javax.sip.header.HeaderAddress;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DeviceControlQueryMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(DeviceControlQueryMessageHandler.class);
    private final String cmdType = "DeviceControl";
    @Autowired
    private ControlMessageHandler controlMessageHandler;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private SIPCommanderFroPlatform cmderFroPlatform;

    public void afterPropertiesSet() throws Exception {
        this.controlMessageHandler.addHandler("DeviceControl", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element element) {
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element rootElement) {
        String targetGBId = ((SipURI)((HeaderAddress)evt.getRequest().getHeader("To")).getAddress().getURI()).getUser();
        String channelId = XmlUtil.getText((Element)rootElement, (String)"DeviceID");
        if (!StringUtils.isEmpty((Object)XmlUtil.getText((Element)rootElement, (String)"TeleBoot")) && parentPlatform.getServerGBId().equals(targetGBId)) {
            this.logger.info("\u6267\u884c\u8fdc\u7a0b\u542f\u52a8\u672c\u5e73\u53f0\u547d\u4ee4");
            this.cmderFroPlatform.unregister(parentPlatform, null, null);
            Thread restartThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            restartThread.setDaemon(false);
            restartThread.start();
        }
        if (!StringUtils.isEmpty((Object)XmlUtil.getText((Element)rootElement, (String)"PTZCmd")) && !parentPlatform.getServerGBId().equals(targetGBId)) {
            String cmdString = XmlUtil.getText((Element)rootElement, (String)"PTZCmd");
            Device deviceForPlatform = this.storager.queryVideoDeviceByPlatformIdAndChannelId(parentPlatform.getServerGBId(), channelId);
            this.cmder.fronEndCmd(deviceForPlatform, channelId, cmdString);
        }
    }
}

