/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.notify.cmd;

import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.gb28181.bean.BaiduPoint;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceAlarm;
import com.genersoft.iot.vmp.gb28181.bean.MobilePosition;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.event.DeviceOffLineDetector;
import com.genersoft.iot.vmp.gb28181.event.EventPublisher;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.notify.NotifyMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.NumericUtil;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import com.genersoft.iot.vmp.service.IDeviceAlarmService;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.utils.GpsUtil;
import javax.sip.RequestEvent;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AlarmNotifyMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(AlarmNotifyMessageHandler.class);
    private final String cmdType = "Alarm";
    @Autowired
    private NotifyMessageHandler notifyMessageHandler;
    @Autowired
    private EventPublisher publisher;
    @Autowired
    private UserSetup userSetup;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IDeviceAlarmService deviceAlarmService;
    @Autowired
    private DeviceOffLineDetector offLineDetector;

    public void afterPropertiesSet() throws Exception {
        this.notifyMessageHandler.addHandler("Alarm", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element rootElement) {
        Element deviceIdElement = rootElement.element("DeviceID");
        String channelId = deviceIdElement.getText().toString();
        DeviceAlarm deviceAlarm = new DeviceAlarm();
        deviceAlarm.setDeviceId(device.getDeviceId());
        deviceAlarm.setChannelId(channelId);
        deviceAlarm.setAlarmPriority(XmlUtil.getText((Element)rootElement, (String)"AlarmPriority"));
        deviceAlarm.setAlarmMethod(XmlUtil.getText((Element)rootElement, (String)"AlarmMethod"));
        deviceAlarm.setAlarmTime(XmlUtil.getText((Element)rootElement, (String)"AlarmTime"));
        if (XmlUtil.getText((Element)rootElement, (String)"AlarmDescription") == null) {
            deviceAlarm.setAlarmDescription("");
        } else {
            deviceAlarm.setAlarmDescription(XmlUtil.getText((Element)rootElement, (String)"AlarmDescription"));
        }
        if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Longitude"))) {
            deviceAlarm.setLongitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Longitude")));
        } else {
            deviceAlarm.setLongitude(0.0);
        }
        if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Latitude"))) {
            deviceAlarm.setLatitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Latitude")));
        } else {
            deviceAlarm.setLatitude(0.0);
        }
        if (!StringUtils.isEmpty((Object)deviceAlarm.getAlarmMethod()) && deviceAlarm.getAlarmMethod().equals("4")) {
            MobilePosition mobilePosition = new MobilePosition();
            mobilePosition.setDeviceId(deviceAlarm.getDeviceId());
            mobilePosition.setTime(deviceAlarm.getAlarmTime());
            mobilePosition.setLongitude(deviceAlarm.getLongitude());
            mobilePosition.setLatitude(deviceAlarm.getLatitude());
            mobilePosition.setReportSource("GPS Alarm");
            BaiduPoint bp = new BaiduPoint();
            bp = GpsUtil.Wgs84ToBd09((String)String.valueOf(mobilePosition.getLongitude()), (String)String.valueOf(mobilePosition.getLatitude()));
            this.logger.info("\u767e\u5ea6\u5750\u6807\uff1a" + bp.getBdLng() + ", " + bp.getBdLat());
            mobilePosition.setGeodeticSystem("BD-09");
            mobilePosition.setCnLng(bp.getBdLng());
            mobilePosition.setCnLat(bp.getBdLat());
            if (!this.userSetup.getSavePositionHistory().booleanValue()) {
                this.storager.clearMobilePositionsByDeviceId(device.getDeviceId());
            }
            this.storager.insertMobilePosition(mobilePosition);
        }
        this.logger.debug("\u5b58\u50a8\u62a5\u8b66\u4fe1\u606f\u3001\u62a5\u8b66\u5206\u7c7b");
        this.deviceAlarmService.add(deviceAlarm);
        if (this.offLineDetector.isOnline(device.getDeviceId())) {
            this.publisher.deviceAlarmEventPublish(deviceAlarm);
        }
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element element) {
    }
}

