/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.notify.cmd;

import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.notify.NotifyMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MediaStatusNotifyMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(MediaStatusNotifyMessageHandler.class);
    private final String cmdType = "MediaStatus";
    @Autowired
    private NotifyMessageHandler notifyMessageHandler;
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;

    public void afterPropertiesSet() throws Exception {
        this.notifyMessageHandler.addHandler("MediaStatus", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element rootElement) {
        try {
            this.responseAck(evt, 200);
        }
        catch (SipException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String NotifyType = XmlUtil.getText((Element)rootElement, (String)"NotifyType");
        if (NotifyType.equals("121")) {
            this.logger.info("\u5a92\u4f53\u64ad\u653e\u5b8c\u6bd5\uff0c\u901a\u77e5\u5173\u6d41");
            StreamInfo streamInfo = this.redisCatchStorage.queryPlaybackByDevice(device.getDeviceId(), "*");
            if (streamInfo != null) {
                this.redisCatchStorage.stopPlayback(streamInfo);
                this.cmder.streamByeCmd(streamInfo.getDeviceID(), streamInfo.getChannelId());
            }
        }
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element element) {
    }
}

