/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.cmd;

import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.event.DeviceOffLineDetector;
import com.genersoft.iot.vmp.gb28181.event.EventPublisher;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.ResponseMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.NumericUtil;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import java.text.ParseException;
import java.util.Iterator;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CatalogResponseMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(CatalogResponseMessageHandler.class);
    private final String cmdType = "Catalog";
    @Autowired
    private ResponseMessageHandler responseMessageHandler;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private DeferredResultHolder deferredResultHolder;
    @Autowired
    private DeviceOffLineDetector offLineDetector;
    @Autowired
    private SipConfig config;
    @Autowired
    private EventPublisher publisher;

    public void afterPropertiesSet() throws Exception {
        this.responseMessageHandler.addHandler("Catalog", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element element) {
        String key = "CALLBACK_CATALOG" + device.getDeviceId();
        Element rootElement = null;
        try {
            rootElement = this.getRootElement(evt, device.getCharset());
            Element deviceListElement = rootElement.element("DeviceList");
            Iterator deviceListIterator = deviceListElement.elementIterator();
            if (deviceListIterator != null) {
                while (deviceListIterator.hasNext()) {
                    Element itemDevice = (Element)deviceListIterator.next();
                    Element channelDeviceElement = itemDevice.element("DeviceID");
                    if (channelDeviceElement == null) continue;
                    String channelDeviceId = channelDeviceElement.getText();
                    Element channdelNameElement = itemDevice.element("Name");
                    String channelName = channdelNameElement != null ? channdelNameElement.getTextTrim().toString() : "";
                    Element statusElement = itemDevice.element("Status");
                    String status = statusElement != null ? statusElement.getText().toString() : "ON";
                    DeviceChannel deviceChannel = new DeviceChannel();
                    deviceChannel.setName(channelName);
                    deviceChannel.setChannelId(channelDeviceId);
                    if (status.equals("ON") || status.equals("On") || status.equals("ONLINE")) {
                        deviceChannel.setStatus(1);
                    }
                    if (status.equals("OFF") || status.equals("Off") || status.equals("OFFLINE")) {
                        deviceChannel.setStatus(0);
                    }
                    deviceChannel.setManufacture(XmlUtil.getText((Element)itemDevice, (String)"Manufacturer"));
                    deviceChannel.setModel(XmlUtil.getText((Element)itemDevice, (String)"Model"));
                    deviceChannel.setOwner(XmlUtil.getText((Element)itemDevice, (String)"Owner"));
                    deviceChannel.setCivilCode(XmlUtil.getText((Element)itemDevice, (String)"CivilCode"));
                    deviceChannel.setBlock(XmlUtil.getText((Element)itemDevice, (String)"Block"));
                    deviceChannel.setAddress(XmlUtil.getText((Element)itemDevice, (String)"Address"));
                    if (XmlUtil.getText((Element)itemDevice, (String)"Parental") == null || XmlUtil.getText((Element)itemDevice, (String)"Parental") == "") {
                        deviceChannel.setParental(0);
                    } else {
                        deviceChannel.setParental(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"Parental")));
                    }
                    deviceChannel.setParentId(XmlUtil.getText((Element)itemDevice, (String)"ParentID"));
                    if (XmlUtil.getText((Element)itemDevice, (String)"SafetyWay") == null || XmlUtil.getText((Element)itemDevice, (String)"SafetyWay") == "") {
                        deviceChannel.setSafetyWay(0);
                    } else {
                        deviceChannel.setSafetyWay(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"SafetyWay")));
                    }
                    if (XmlUtil.getText((Element)itemDevice, (String)"RegisterWay") == null || XmlUtil.getText((Element)itemDevice, (String)"RegisterWay") == "") {
                        deviceChannel.setRegisterWay(1);
                    } else {
                        deviceChannel.setRegisterWay(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"RegisterWay")));
                    }
                    deviceChannel.setCertNum(XmlUtil.getText((Element)itemDevice, (String)"CertNum"));
                    if (XmlUtil.getText((Element)itemDevice, (String)"Certifiable") == null || XmlUtil.getText((Element)itemDevice, (String)"Certifiable") == "") {
                        deviceChannel.setCertifiable(0);
                    } else {
                        deviceChannel.setCertifiable(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"Certifiable")));
                    }
                    if (XmlUtil.getText((Element)itemDevice, (String)"ErrCode") == null || XmlUtil.getText((Element)itemDevice, (String)"ErrCode") == "") {
                        deviceChannel.setErrCode(0);
                    } else {
                        deviceChannel.setErrCode(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"ErrCode")));
                    }
                    deviceChannel.setEndTime(XmlUtil.getText((Element)itemDevice, (String)"EndTime"));
                    deviceChannel.setSecrecy(XmlUtil.getText((Element)itemDevice, (String)"Secrecy"));
                    deviceChannel.setIpAddress(XmlUtil.getText((Element)itemDevice, (String)"IPAddress"));
                    if (XmlUtil.getText((Element)itemDevice, (String)"Port") == null || XmlUtil.getText((Element)itemDevice, (String)"Port") == "") {
                        deviceChannel.setPort(0);
                    } else {
                        deviceChannel.setPort(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"Port")));
                    }
                    deviceChannel.setPassword(XmlUtil.getText((Element)itemDevice, (String)"Password"));
                    if (NumericUtil.isDouble((String)XmlUtil.getText((Element)itemDevice, (String)"Longitude"))) {
                        deviceChannel.setLongitude(Double.parseDouble(XmlUtil.getText((Element)itemDevice, (String)"Longitude")));
                    } else {
                        deviceChannel.setLongitude(0.0);
                    }
                    if (NumericUtil.isDouble((String)XmlUtil.getText((Element)itemDevice, (String)"Latitude"))) {
                        deviceChannel.setLatitude(Double.parseDouble(XmlUtil.getText((Element)itemDevice, (String)"Latitude")));
                    } else {
                        deviceChannel.setLatitude(0.0);
                    }
                    if (XmlUtil.getText((Element)itemDevice, (String)"PTZType") == null || XmlUtil.getText((Element)itemDevice, (String)"PTZType") == "") {
                        deviceChannel.setPTZType(0);
                    } else {
                        deviceChannel.setPTZType(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"PTZType")));
                    }
                    deviceChannel.setHasAudio(true);
                    this.storager.updateChannel(device.getDeviceId(), deviceChannel);
                }
                RequestMessage msg = new RequestMessage();
                msg.setKey(key);
                msg.setData((Object)device);
                this.deferredResultHolder.invokeAllResult(msg);
                this.responseAck(evt, 200);
                if (this.offLineDetector.isOnline(device.getDeviceId())) {
                    this.publisher.onlineEventPublish(device, "3");
                }
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SipException e) {
            e.printStackTrace();
        }
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element rootElement) {
    }
}

