/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.cmd;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.event.DeviceOffLineDetector;
import com.genersoft.iot.vmp.gb28181.event.EventPublisher;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.ResponseMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeviceStatusResponseMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(DeviceStatusResponseMessageHandler.class);
    private final String cmdType = "DeviceStatus";
    @Autowired
    private ResponseMessageHandler responseMessageHandler;
    @Autowired
    private DeviceOffLineDetector offLineDetector;
    @Autowired
    private DeferredResultHolder deferredResultHolder;
    @Autowired
    private EventPublisher publisher;

    public void afterPropertiesSet() throws Exception {
        this.responseMessageHandler.addHandler("DeviceStatus", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element element) {
        this.logger.info("\u63a5\u6536\u5230DeviceStatus\u5e94\u7b54\u6d88\u606f");
        try {
            this.responseAck(evt, 200);
        }
        catch (SipException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Element deviceIdElement = element.element("DeviceID");
        String channelId = deviceIdElement.getText();
        JSONObject json = new JSONObject();
        XmlUtil.node2Json((Element)element, (JSONObject)json);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(json.toJSONString());
        }
        RequestMessage msg = new RequestMessage();
        msg.setKey("CALLBACK_DEVICESTATUS" + device.getDeviceId() + channelId);
        msg.setData((Object)json);
        this.deferredResultHolder.invokeAllResult(msg);
        if (this.offLineDetector.isOnline(device.getDeviceId())) {
            this.publisher.onlineEventPublish(device, "3");
        }
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element rootElement) {
    }
}

