/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.response.impl;

import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.SipLayer;
import com.genersoft.iot.vmp.gb28181.session.VideoStreamSessionManager;
import com.genersoft.iot.vmp.gb28181.transmit.SIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.event.response.ISIPResponseProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.response.SIPResponseProcessorAbstract;
import gov.nist.javax.sip.ResponseEventExt;
import gov.nist.javax.sip.stack.SIPDialog;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InviteResponseProcessor
extends SIPResponseProcessorAbstract {
    private static final Logger logger = LoggerFactory.getLogger(InviteResponseProcessor.class);
    private String method = "INVITE";
    @Autowired
    private SipLayer sipLayer;
    @Autowired
    private SipConfig config;
    @Autowired
    private SIPProcessorObserver sipProcessorObserver;
    @Autowired
    private VideoStreamSessionManager streamSession;

    public void afterPropertiesSet() throws Exception {
        this.sipProcessorObserver.addResponseProcessor(this.method, (ISIPResponseProcessor)this);
    }

    public void process(ResponseEvent evt) {
        block5: {
            try {
                Response response = evt.getResponse();
                int statusCode = response.getStatusCode();
                if (statusCode == 100) {
                    // empty if block
                }
                if (statusCode != 200) break block5;
                ResponseEventExt event = (ResponseEventExt)evt;
                SIPDialog dialog = (SIPDialog)evt.getDialog();
                CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
                Request reqAck = dialog.createAck(cseq.getSeqNumber());
                SipURI requestURI = (SipURI)reqAck.getRequestURI();
                try {
                    requestURI.setHost(event.getRemoteIpAddress());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                requestURI.setPort(event.getRemotePort());
                reqAck.setRequestURI((URI)requestURI);
                logger.info("\u5411 " + event.getRemoteIpAddress() + ":" + event.getRemotePort() + "\u56de\u590dack");
                SipURI sipURI = (SipURI)dialog.getRemoteParty().getURI();
                String deviceId = requestURI.getUser();
                String channelId = sipURI.getUser();
                dialog.sendAck(reqAck);
            }
            catch (InvalidArgumentException | SipException e) {
                e.printStackTrace();
            }
        }
    }
}

