/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.media.zlm;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.media.zlm.ZLMHttpHookSubscribe;
import com.genersoft.iot.vmp.media.zlm.ZLMRESTfulUtils;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.media.zlm.dto.StreamProxyItem;
import com.genersoft.iot.vmp.media.zlm.dto.StreamPushItem;
import com.genersoft.iot.vmp.service.IStreamPushService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.storager.dao.GbStreamMapper;
import com.genersoft.iot.vmp.storager.dao.PlatformGbStreamMapper;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ZLMMediaListManager {
    private Logger logger = LoggerFactory.getLogger((String)"ZLMMediaListManager");
    @Autowired
    private ZLMRESTfulUtils zlmresTfulUtils;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private GbStreamMapper gbStreamMapper;
    @Autowired
    private PlatformGbStreamMapper platformGbStreamMapper;
    @Autowired
    private IStreamPushService streamPushService;
    @Autowired
    private ZLMHttpHookSubscribe subscribe;

    public void updateMediaList(MediaServerItem mediaServerItem) {
        this.storager.clearMediaList();
        this.zlmresTfulUtils.getMediaList(mediaServerItem, mediaList -> {
            if (mediaList == null) {
                return;
            }
            String dataStr = mediaList.getString("data");
            Integer code = mediaList.getInteger("code");
            HashMap result = new HashMap();
            List streamPushItems = null;
            if (code == 0) {
                if (dataStr != null) {
                    streamPushItems = this.streamPushService.handleJSON(dataStr, mediaServerItem);
                }
            } else {
                this.logger.warn("\u66f4\u65b0\u89c6\u9891\u6d41\u5931\u8d25\uff0c\u9519\u8befcode\uff1a " + code);
            }
            if (streamPushItems != null) {
                this.storager.updateMediaList(streamPushItems);
                for (StreamPushItem streamPushItem : streamPushItems) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("app", (Object)streamPushItem.getApp());
                    jsonObject.put("stream", (Object)streamPushItem.getStream());
                    jsonObject.put("mediaServerId", (Object)mediaServerItem.getId());
                    this.subscribe.addSubscribe(ZLMHttpHookSubscribe.HookType.on_play, jsonObject, (mediaServerItemInuse, response) -> this.updateMedia(mediaServerItem, response.getString("app"), response.getString("stream")));
                }
            }
        });
    }

    public void addMedia(MediaServerItem mediaServerItem, String app, String streamId) {
        this.updateMedia(mediaServerItem, app, streamId);
    }

    public void updateMedia(MediaServerItem mediaServerItem, String app, String streamId) {
        this.zlmresTfulUtils.getMediaList(mediaServerItem, app, streamId, "rtmp", json -> {
            if (json == null) {
                return;
            }
            String dataStr = json.getString("data");
            Integer code = json.getInteger("code");
            HashMap result = new HashMap();
            List streamPushItems = null;
            if (code == 0) {
                if (dataStr != null) {
                    streamPushItems = this.streamPushService.handleJSON(dataStr, mediaServerItem);
                }
            } else {
                this.logger.warn("\u66f4\u65b0\u89c6\u9891\u6d41\u5931\u8d25\uff0c\u9519\u8befcode\uff1a " + code);
            }
            if (streamPushItems != null && streamPushItems.size() == 1) {
                this.storager.updateMedia((StreamPushItem)streamPushItems.get(0));
            }
        });
    }

    public void removeMedia(String app, String streamId) {
        StreamProxyItem streamProxyItem = this.gbStreamMapper.selectOne(app, streamId);
        if (streamProxyItem == null) {
            this.storager.removeMedia(app, streamId);
        } else {
            this.storager.mediaOutline(app, streamId);
        }
    }
}

