/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.media.zlm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.media.zlm.ZLMRESTfulUtils;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZLMRESTfulUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZLMRESTfulUtils.class);

    public JSONObject sendPost(MediaServerItem mediaServerItem, String api, Map<String, Object> param, RequestCallback callback) {
        JSONObject responseJSON;
        block9: {
            OkHttpClient client = new OkHttpClient();
            String url = String.format("http://%s:%s/index/api/%s", mediaServerItem.getIp(), mediaServerItem.getHttpPort(), api);
            responseJSON = null;
            FormBody.Builder builder = new FormBody.Builder();
            builder.add("secret", mediaServerItem.getSecret());
            if (param != null && param.keySet().size() > 0) {
                for (String key : param.keySet()) {
                    if (param.get(key) == null) continue;
                    builder.add(key, param.get(key).toString());
                }
            }
            FormBody body = builder.build();
            Request request = new Request.Builder().post((RequestBody)body).url(url).build();
            if (callback == null) {
                try {
                    Response response = client.newCall(request).execute();
                    if (response.isSuccessful()) {
                        ResponseBody responseBody = response.body();
                        if (responseBody != null) {
                            String responseStr = responseBody.string();
                            responseJSON = JSON.parseObject((String)responseStr);
                        }
                        break block9;
                    }
                    response.close();
                    Objects.requireNonNull(response.body()).close();
                }
                catch (ConnectException e) {
                    logger.error(String.format("\u8fde\u63a5ZLM\u5931\u8d25: %s, %s", e.getCause().getMessage(), e.getMessage()));
                    logger.info("\u8bf7\u68c0\u67e5media\u914d\u7f6e\u5e76\u786e\u8ba4ZLM\u5df2\u542f\u52a8...");
                }
                catch (IOException e) {
                    logger.error(String.format("[ %s ]\u8bf7\u6c42\u5931\u8d25: %s", url, e.getMessage()));
                }
            } else {
                client.newCall(request).enqueue((Callback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        return responseJSON;
    }

    public void sendGetForImg(MediaServerItem mediaServerItem, String api, Map<String, Object> params, String targetPath, String fileName) {
        String url = String.format("http://%s:%s/index/api/%s", mediaServerItem.getIp(), mediaServerItem.getHttpPort(), api);
        logger.debug(url);
        HttpUrl parseUrl = HttpUrl.parse((String)url);
        if (parseUrl == null) {
            return;
        }
        HttpUrl.Builder httpBuilder = parseUrl.newBuilder();
        httpBuilder.addQueryParameter("secret", mediaServerItem.getSecret());
        if (params != null) {
            for (Map.Entry<String, Object> param : params.entrySet()) {
                httpBuilder.addQueryParameter(param.getKey(), param.getValue().toString());
            }
        }
        Request request = new Request.Builder().url(httpBuilder.build()).build();
        logger.info(request.toString());
        try {
            OkHttpClient client = new OkHttpClient.Builder().readTimeout(10L, TimeUnit.SECONDS).build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                logger.info("response body contentType: " + Objects.requireNonNull(response.body()).contentType());
                if (targetPath != null) {
                    File snapFolder = new File(targetPath);
                    if (!snapFolder.exists() && !snapFolder.mkdirs()) {
                        logger.warn("{}\u8def\u5f84\u521b\u5efa\u5931\u8d25", (Object)snapFolder.getAbsolutePath());
                    }
                    File snapFile = new File(targetPath + "/" + fileName);
                    FileOutputStream outStream = new FileOutputStream(snapFile);
                    outStream.write(Objects.requireNonNull(response.body()).bytes());
                    outStream.close();
                } else {
                    logger.error(String.format("[ %s ]\u8bf7\u6c42\u5931\u8d25: %s %s", url, response.code(), response.message()));
                }
                Objects.requireNonNull(response.body()).close();
            } else {
                logger.error(String.format("[ %s ]\u8bf7\u6c42\u5931\u8d25: %s %s", url, response.code(), response.message()));
            }
        }
        catch (ConnectException e) {
            logger.error(String.format("\u8fde\u63a5ZLM\u5931\u8d25: %s, %s", e.getCause().getMessage(), e.getMessage()));
            logger.info("\u8bf7\u68c0\u67e5media\u914d\u7f6e\u5e76\u786e\u8ba4ZLM\u5df2\u542f\u52a8...");
        }
        catch (IOException e) {
            logger.error(String.format("[ %s ]\u8bf7\u6c42\u5931\u8d25: %s", url, e.getMessage()));
        }
    }

    public JSONObject getMediaList(MediaServerItem mediaServerItem, String app, String stream, String schema, RequestCallback callback) {
        HashMap<String, String> param = new HashMap<String, String>();
        if (app != null) {
            param.put("app", app);
        }
        if (stream != null) {
            param.put("stream", stream);
        }
        if (schema != null) {
            param.put("schema", schema);
        }
        param.put("vhost", "__defaultVhost__");
        return this.sendPost(mediaServerItem, "getMediaList", param, callback);
    }

    public JSONObject getMediaList(MediaServerItem mediaServerItem, String app, String stream) {
        return this.getMediaList(mediaServerItem, app, stream, null, null);
    }

    public JSONObject getMediaList(MediaServerItem mediaServerItem, RequestCallback callback) {
        return this.sendPost(mediaServerItem, "getMediaList", null, callback);
    }

    public JSONObject getMediaInfo(MediaServerItem mediaServerItem, String app, String schema, String stream) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("app", app);
        param.put("schema", schema);
        param.put("stream", stream);
        param.put("vhost", "__defaultVhost__");
        return this.sendPost(mediaServerItem, "getMediaInfo", param, null);
    }

    public JSONObject getRtpInfo(MediaServerItem mediaServerItem, String stream_id) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("stream_id", stream_id);
        return this.sendPost(mediaServerItem, "getRtpInfo", param, null);
    }

    public JSONObject addFFmpegSource(MediaServerItem mediaServerItem, String src_url, String dst_url, String timeout_ms, boolean enable_hls, boolean enable_mp4, String ffmpeg_cmd_key) {
        logger.info(src_url);
        logger.info(dst_url);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("src_url", src_url);
        param.put("dst_url", dst_url);
        param.put("timeout_ms", timeout_ms);
        param.put("enable_hls", enable_hls);
        param.put("enable_mp4", enable_mp4);
        param.put("ffmpeg_cmd_key", ffmpeg_cmd_key);
        return this.sendPost(mediaServerItem, "addFFmpegSource", param, null);
    }

    public JSONObject delFFmpegSource(MediaServerItem mediaServerItem, String key) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("key", key);
        return this.sendPost(mediaServerItem, "delFFmpegSource", param, null);
    }

    public JSONObject getMediaServerConfig(MediaServerItem mediaServerItem) {
        return this.sendPost(mediaServerItem, "getServerConfig", null, null);
    }

    public JSONObject setServerConfig(MediaServerItem mediaServerItem, Map<String, Object> param) {
        return this.sendPost(mediaServerItem, "setServerConfig", param, null);
    }

    public JSONObject openRtpServer(MediaServerItem mediaServerItem, Map<String, Object> param) {
        return this.sendPost(mediaServerItem, "openRtpServer", param, null);
    }

    public JSONObject closeRtpServer(MediaServerItem mediaServerItem, Map<String, Object> param) {
        return this.sendPost(mediaServerItem, "closeRtpServer", param, null);
    }

    public JSONObject listRtpServer(MediaServerItem mediaServerItem) {
        return this.sendPost(mediaServerItem, "listRtpServer", null, null);
    }

    public JSONObject startSendRtp(MediaServerItem mediaServerItem, Map<String, Object> param) {
        return this.sendPost(mediaServerItem, "startSendRtp", param, null);
    }

    public JSONObject stopSendRtp(MediaServerItem mediaServerItem, Map<String, Object> param) {
        return this.sendPost(mediaServerItem, "stopSendRtp", param, null);
    }

    public JSONObject addStreamProxy(MediaServerItem mediaServerItem, String app, String stream, String url, boolean enable_hls, boolean enable_mp4, String rtp_type) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("vhost", "__defaultVhost__");
        param.put("app", app);
        param.put("stream", stream);
        param.put("url", url);
        param.put("enable_hls", enable_hls ? 1 : 0);
        param.put("enable_mp4", enable_mp4 ? 1 : 0);
        param.put("rtp_type", rtp_type);
        return this.sendPost(mediaServerItem, "addStreamProxy", param, null);
    }

    public JSONObject closeStreams(MediaServerItem mediaServerItem, String app, String stream) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("vhost", "__defaultVhost__");
        param.put("app", app);
        param.put("stream", stream);
        param.put("force", 1);
        return this.sendPost(mediaServerItem, "close_streams", param, null);
    }

    public JSONObject getAllSession(MediaServerItem mediaServerItem) {
        return this.sendPost(mediaServerItem, "getAllSession", null, null);
    }

    public void kickSessions(MediaServerItem mediaServerItem, String localPortSStr) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("local_port", localPortSStr);
        this.sendPost(mediaServerItem, "kick_sessions", param, null);
    }

    public void getSnap(MediaServerItem mediaServerItem, String flvUrl, int timeout_sec, int expire_sec, String targetPath, String fileName) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("url", flvUrl);
        param.put("timeout_sec", timeout_sec);
        param.put("expire_sec", expire_sec);
        this.sendGetForImg(mediaServerItem, "getSnap", param, targetPath, fileName);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

