/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.gb28181.event.SipSubscribe;
import com.genersoft.iot.vmp.gb28181.session.VideoStreamSessionManager;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.media.zlm.ZLMHttpHookSubscribe;
import com.genersoft.iot.vmp.media.zlm.ZLMRESTfulUtils;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.IMediaService;
import com.genersoft.iot.vmp.service.IPlayService;
import com.genersoft.iot.vmp.service.bean.SSRCInfo;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.utils.redis.RedisUtil;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import com.genersoft.iot.vmp.vmanager.gb28181.play.bean.PlayResult;
import gov.nist.javax.sip.stack.SIPDialog;
import java.io.FileNotFoundException;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class PlayServiceImpl
implements IPlayService {
    private static final Logger logger = LoggerFactory.getLogger(PlayServiceImpl.class);
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private RedisUtil redis;
    @Autowired
    private DeferredResultHolder resultHolder;
    @Autowired
    private ZLMRESTfulUtils zlmresTfulUtils;
    @Autowired
    private IMediaService mediaService;
    @Autowired
    private IMediaServerService mediaServerService;
    @Autowired
    private VideoStreamSessionManager streamSession;
    @Autowired
    private UserSetup userSetup;

    public PlayResult play(MediaServerItem mediaServerItem, String deviceId, String channelId, ZLMHttpHookSubscribe.Event hookEvent, SipSubscribe.Event errorEvent) {
        PlayResult playResult = new PlayResult();
        RequestMessage msg = new RequestMessage();
        String key = "CALLBACK_PLAY" + deviceId + channelId;
        msg.setKey(key);
        String uuid = UUID.randomUUID().toString();
        msg.setId(uuid);
        playResult.setUuid(uuid);
        DeferredResult result = new DeferredResult(this.userSetup.getPlayTimeout());
        playResult.setResult(result);
        this.resultHolder.put(key, uuid, result);
        if (mediaServerItem == null) {
            WVPResult wvpResult = new WVPResult();
            wvpResult.setCode(-1);
            wvpResult.setMsg("\u672a\u627e\u5230\u53ef\u7528\u7684zlm");
            msg.setData((Object)wvpResult);
            this.resultHolder.invokeResult(msg);
            return playResult;
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        StreamInfo streamInfo = this.redisCatchStorage.queryPlayByDevice(deviceId, channelId);
        playResult.setDevice(device);
        result.onTimeout(() -> {
            logger.warn(String.format("\u8bbe\u5907\u70b9\u64ad\u8d85\u65f6\uff0cdeviceId\uff1a%s \uff0cchannelId\uff1a%s", deviceId, channelId));
            WVPResult wvpResult = new WVPResult();
            wvpResult.setCode(-1);
            SIPDialog dialog = this.streamSession.getDialog(deviceId, channelId);
            if (dialog != null) {
                wvpResult.setMsg("\u6536\u6d41\u8d85\u65f6\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5");
            } else {
                wvpResult.setMsg("\u70b9\u64ad\u8d85\u65f6\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5");
            }
            msg.setData((Object)wvpResult);
            this.cmder.streamByeCmd(device.getDeviceId(), channelId);
            this.mediaServerService.closeRTPServer(playResult.getDevice(), channelId);
            this.resultHolder.invokeAllResult(msg);
        });
        result.onCompletion(() -> {
            try {
                WVPResult wvpResult;
                String classPath = ResourceUtils.getURL((String)"classpath:").getPath();
                if (classPath.contains("jar")) {
                    classPath = classPath.substring(0, classPath.lastIndexOf("."));
                    classPath = classPath.substring(0, classPath.lastIndexOf("/") + 1);
                }
                if (classPath.startsWith("file:")) {
                    classPath = classPath.substring(classPath.indexOf(":") + 1);
                }
                String path = classPath + "static/static/snap/";
                if (System.getProperty("os.name").contains("indows")) {
                    path = path.substring(1);
                }
                String fileName = deviceId + "_" + channelId + ".jpg";
                ResponseEntity responseEntity = (ResponseEntity)result.getResult();
                if (responseEntity != null && responseEntity.getStatusCode() == HttpStatus.OK && Objects.requireNonNull(wvpResult = (WVPResult)responseEntity.getBody()).getCode() == 0) {
                    StreamInfo streamInfoForSuccess = (StreamInfo)wvpResult.getData();
                    MediaServerItem mediaInfo = this.mediaServerService.getOne(streamInfoForSuccess.getMediaServerId());
                    String streamUrl = streamInfoForSuccess.getFmp4();
                    this.zlmresTfulUtils.getSnap(mediaInfo, streamUrl, 15, 1, path, fileName);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        });
        if (streamInfo == null) {
            String streamId = null;
            if (mediaServerItem.isRtpEnable()) {
                streamId = String.format("%s_%s", device.getDeviceId(), channelId);
            }
            SSRCInfo ssrcInfo = this.mediaServerService.openRTPServer(mediaServerItem, streamId);
            this.cmder.playStreamCmd(mediaServerItem, ssrcInfo, device, channelId, (mediaServerItemInUse, response) -> {
                logger.info("\u6536\u5230\u8ba2\u9605\u6d88\u606f\uff1a " + response.toJSONString());
                this.onPublishHandlerForPlay(mediaServerItemInUse, response, deviceId, channelId, uuid);
                if (hookEvent != null) {
                    hookEvent.response(mediaServerItem, response);
                }
            }, event -> {
                WVPResult wvpResult = new WVPResult();
                wvpResult.setCode(-1);
                this.mediaServerService.closeRTPServer(playResult.getDevice(), channelId);
                wvpResult.setMsg(String.format("\u70b9\u64ad\u5931\u8d25\uff0c \u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
                msg.setData((Object)wvpResult);
                this.resultHolder.invokeAllResult(msg);
                if (errorEvent != null) {
                    errorEvent.response(event);
                }
            });
        } else {
            String streamId = streamInfo.getStreamId();
            if (streamId == null) {
                WVPResult wvpResult = new WVPResult();
                wvpResult.setCode(-1);
                wvpResult.setMsg("\u70b9\u64ad\u5931\u8d25\uff0c redis\u7f13\u5b58streamId\u7b49\u4e8enull");
                msg.setData((Object)wvpResult);
                this.resultHolder.invokeAllResult(msg);
                return playResult;
            }
            String mediaServerId = streamInfo.getMediaServerId();
            MediaServerItem mediaInfo = this.mediaServerService.getOne(mediaServerId);
            JSONObject rtpInfo = this.zlmresTfulUtils.getRtpInfo(mediaInfo, streamId);
            if (rtpInfo != null && rtpInfo.getBoolean("exist").booleanValue()) {
                WVPResult wvpResult = new WVPResult();
                wvpResult.setCode(0);
                wvpResult.setMsg("success");
                wvpResult.setData((Object)streamInfo);
                msg.setData((Object)wvpResult);
                this.resultHolder.invokeAllResult(msg);
                if (hookEvent != null) {
                    hookEvent.response(mediaServerItem, JSONObject.parseObject((String)JSON.toJSONString((Object)streamInfo)));
                }
            } else {
                this.redisCatchStorage.stopPlay(streamInfo);
                this.storager.stopPlay(streamInfo.getDeviceID(), streamInfo.getChannelId());
                String streamId2 = null;
                if (mediaServerItem.isRtpEnable()) {
                    streamId2 = String.format("%s_%s", device.getDeviceId(), channelId);
                }
                SSRCInfo ssrcInfo = this.mediaServerService.openRTPServer(mediaServerItem, streamId2);
                this.cmder.playStreamCmd(mediaServerItem, ssrcInfo, device, channelId, (mediaServerItemInuse, response) -> {
                    logger.info("\u6536\u5230\u8ba2\u9605\u6d88\u606f\uff1a " + response.toJSONString());
                    this.onPublishHandlerForPlay(mediaServerItemInuse, response, deviceId, channelId, uuid);
                }, event -> {
                    this.mediaServerService.closeRTPServer(playResult.getDevice(), channelId);
                    WVPResult wvpResult = new WVPResult();
                    wvpResult.setCode(-1);
                    wvpResult.setMsg(String.format("\u70b9\u64ad\u5931\u8d25\uff0c \u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
                    msg.setData((Object)wvpResult);
                    this.resultHolder.invokeAllResult(msg);
                });
            }
        }
        return playResult;
    }

    public void onPublishHandlerForPlay(MediaServerItem mediaServerItem, JSONObject resonse, String deviceId, String channelId, String uuid) {
        RequestMessage msg = new RequestMessage();
        msg.setId(uuid);
        msg.setKey("CALLBACK_PLAY" + deviceId + channelId);
        StreamInfo streamInfo = this.onPublishHandler(mediaServerItem, resonse, deviceId, channelId, uuid);
        if (streamInfo != null) {
            DeviceChannel deviceChannel = this.storager.queryChannel(deviceId, channelId);
            if (deviceChannel != null) {
                deviceChannel.setStreamId(streamInfo.getStreamId());
                this.storager.startPlay(deviceId, channelId, streamInfo.getStreamId());
            }
            this.redisCatchStorage.startPlay(streamInfo);
            msg.setData((Object)JSON.toJSONString((Object)streamInfo));
            WVPResult wvpResult = new WVPResult();
            wvpResult.setCode(0);
            wvpResult.setMsg("success");
            wvpResult.setData((Object)streamInfo);
            msg.setData((Object)wvpResult);
            this.resultHolder.invokeAllResult(msg);
        } else {
            logger.warn("\u8bbe\u5907\u9884\u89c8API\u8c03\u7528\u5931\u8d25\uff01");
            msg.setData((Object)"\u8bbe\u5907\u9884\u89c8API\u8c03\u7528\u5931\u8d25\uff01");
            this.resultHolder.invokeAllResult(msg);
        }
    }

    public MediaServerItem getNewMediaServerItem(Device device) {
        if (device == null) {
            return null;
        }
        String mediaServerId = device.getMediaServerId();
        MediaServerItem mediaServerItem = mediaServerId == null ? this.mediaServerService.getMediaServerForMinimumLoad() : this.mediaServerService.getOne(mediaServerId);
        if (mediaServerItem == null) {
            logger.warn("\u70b9\u64ad\u65f6\u672a\u627e\u5230\u53ef\u4f7f\u7528\u7684ZLM...");
        }
        return mediaServerItem;
    }

    public void onPublishHandlerForPlayBack(MediaServerItem mediaServerItem, JSONObject resonse, String deviceId, String channelId, String uuid) {
        RequestMessage msg = new RequestMessage();
        msg.setKey("CALLBACK_PLAY" + deviceId + channelId);
        msg.setId(uuid);
        StreamInfo streamInfo = this.onPublishHandler(mediaServerItem, resonse, deviceId, channelId, uuid);
        if (streamInfo != null) {
            this.redisCatchStorage.startPlayback(streamInfo);
            msg.setData((Object)JSON.toJSONString((Object)streamInfo));
            this.resultHolder.invokeResult(msg);
        } else {
            logger.warn("\u8bbe\u5907\u9884\u89c8API\u8c03\u7528\u5931\u8d25\uff01");
            msg.setData((Object)"\u8bbe\u5907\u9884\u89c8API\u8c03\u7528\u5931\u8d25\uff01");
            this.resultHolder.invokeResult(msg);
        }
    }

    public StreamInfo onPublishHandler(MediaServerItem mediaServerItem, JSONObject resonse, String deviceId, String channelId, String uuid) {
        String streamId = resonse.getString("stream");
        JSONArray tracks = resonse.getJSONArray("tracks");
        StreamInfo streamInfo = this.mediaService.getStreamInfoByAppAndStream(mediaServerItem, "rtp", streamId, tracks);
        streamInfo.setDeviceID(deviceId);
        streamInfo.setChannelId(channelId);
        return streamInfo;
    }
}

