/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.storager.impl;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatformCatch;
import com.genersoft.iot.vmp.gb28181.bean.SendRtpItem;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.dao.DeviceChannelMapper;
import com.genersoft.iot.vmp.utils.redis.RedisUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisCatchStorageImpl
implements IRedisCatchStorage {
    @Autowired
    private RedisUtil redis;
    @Autowired
    private DeviceChannelMapper deviceChannelMapper;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public boolean startPlay(StreamInfo stream) {
        return this.redis.set(String.format("%S_%s_%s_%s", "VMP_PLAYER_", stream.getStreamId(), stream.getDeviceID(), stream.getChannelId()), (Object)stream);
    }

    public boolean stopPlay(StreamInfo streamInfo) {
        if (streamInfo == null) {
            return false;
        }
        return this.redis.del(new String[]{String.format("%S_%s_%s_%s", "VMP_PLAYER_", streamInfo.getStreamId(), streamInfo.getDeviceID(), streamInfo.getChannelId())});
    }

    public StreamInfo queryPlay(StreamInfo streamInfo) {
        return (StreamInfo)this.redis.get(String.format("%S_%s_%s_%s", "VMP_PLAYER_", streamInfo.getStreamId(), streamInfo.getDeviceID(), streamInfo.getChannelId()));
    }

    public StreamInfo queryPlayByStreamId(String steamId) {
        List playLeys = this.redis.scan(String.format("%S_%s_*", "VMP_PLAYER_", steamId));
        if (playLeys == null || playLeys.size() == 0) {
            return null;
        }
        return (StreamInfo)this.redis.get(playLeys.get(0).toString());
    }

    public StreamInfo queryPlaybackByStreamId(String steamId) {
        List playLeys = this.redis.scan(String.format("%S_%s_*", "VMP_PLAYBACK_", steamId));
        if (playLeys == null || playLeys.size() == 0) {
            return null;
        }
        return (StreamInfo)this.redis.get(playLeys.get(0).toString());
    }

    public StreamInfo queryPlayByDevice(String deviceId, String channelId) {
        List playLeys = this.redis.scan(String.format("%S_*_%s_%s", "VMP_PLAYER_", deviceId, channelId));
        if (playLeys == null || playLeys.size() == 0) {
            return null;
        }
        return (StreamInfo)this.redis.get(playLeys.get(0).toString());
    }

    public Map<String, StreamInfo> queryPlayByDeviceId(String deviceId) {
        HashMap<String, StreamInfo> streamInfos = new HashMap<String, StreamInfo>();
        List players = this.redis.scan(String.format("%S_*_%S_*", "VMP_PLAYER_", deviceId));
        if (players.size() == 0) {
            return streamInfos;
        }
        for (int i = 0; i < players.size(); ++i) {
            String key = (String)players.get(i);
            StreamInfo streamInfo = (StreamInfo)this.redis.get(key);
            streamInfos.put(streamInfo.getDeviceID() + "_" + streamInfo.getChannelId(), streamInfo);
        }
        return streamInfos;
    }

    public boolean startPlayback(StreamInfo stream) {
        return this.redis.set(String.format("%S_%s_%s_%s", "VMP_PLAYBACK_", stream.getStreamId(), stream.getDeviceID(), stream.getChannelId()), (Object)stream);
    }

    public boolean stopPlayback(StreamInfo streamInfo) {
        if (streamInfo == null) {
            return false;
        }
        DeviceChannel deviceChannel = this.deviceChannelMapper.queryChannel(streamInfo.getDeviceID(), streamInfo.getChannelId());
        if (deviceChannel != null) {
            deviceChannel.setStreamId(null);
            deviceChannel.setDeviceId(streamInfo.getDeviceID());
            this.deviceChannelMapper.update(deviceChannel);
        }
        return this.redis.del(new String[]{String.format("%S_%s_%s_%s", "VMP_PLAYBACK_", streamInfo.getStreamId(), streamInfo.getDeviceID(), streamInfo.getChannelId())});
    }

    public StreamInfo queryPlaybackByDevice(String deviceId, String code) {
        List playLeys = this.redis.scan(String.format("%S_*_%s_%s", "VMP_PLAYBACK_", deviceId, code));
        if (playLeys == null || playLeys.size() == 0) {
            playLeys = this.redis.scan(String.format("%S_*_*_%s", "VMP_PLAYBACK_", deviceId));
        }
        if (playLeys == null || playLeys.size() == 0) {
            return null;
        }
        return (StreamInfo)this.redis.get(playLeys.get(0).toString());
    }

    public void updatePlatformCatchInfo(ParentPlatformCatch parentPlatformCatch) {
        String key = "VMP_PLATFORM_CATCH_" + parentPlatformCatch.getId();
        this.redis.set(key, (Object)parentPlatformCatch);
    }

    public void updatePlatformKeepalive(ParentPlatform parentPlatform) {
        String key = "VMP_PLATFORM_KEEPLIVE_" + parentPlatform.getServerGBId();
        this.redis.set(key, (Object)"", (long)Integer.parseInt(parentPlatform.getKeepTimeout()));
    }

    public void updatePlatformRegister(ParentPlatform parentPlatform) {
        String key = "VMP_PLATFORM_REGISTER_" + parentPlatform.getServerGBId();
        this.redis.set(key, (Object)"", (long)Integer.parseInt(parentPlatform.getExpires()));
    }

    public ParentPlatformCatch queryPlatformCatchInfo(String platformGbId) {
        return (ParentPlatformCatch)this.redis.get("VMP_PLATFORM_CATCH_" + platformGbId);
    }

    public void delPlatformCatchInfo(String platformGbId) {
        this.redis.del(new String[]{"VMP_PLATFORM_CATCH_" + platformGbId});
    }

    public void delPlatformKeepalive(String platformGbId) {
        this.redis.del(new String[]{"VMP_PLATFORM_KEEPLIVE_" + platformGbId});
    }

    public void delPlatformRegister(String platformGbId) {
        this.redis.del(new String[]{"VMP_PLATFORM_REGISTER_" + platformGbId});
    }

    public void updatePlatformRegisterInfo(String callId, String platformGbId) {
        String key = "VMP_PLATFORM_REGISTER_INFO_" + callId;
        this.redis.set(key, (Object)platformGbId);
    }

    public String queryPlatformRegisterInfo(String callId) {
        return (String)this.redis.get("VMP_PLATFORM_REGISTER_INFO_" + callId);
    }

    public void delPlatformRegisterInfo(String callId) {
        this.redis.del(new String[]{"VMP_PLATFORM_REGISTER_INFO_" + callId});
    }

    public void cleanPlatformRegisterInfos() {
        List regInfos = this.redis.scan("VMP_PLATFORM_REGISTER_INFO_*");
        for (Object key : regInfos) {
            this.redis.del(new String[]{key.toString()});
        }
    }

    public void updateSendRTPSever(SendRtpItem sendRtpItem) {
        String key = "VMP_PLATFORM_SEND_RTP_INFO_" + sendRtpItem.getPlatformId() + "_" + sendRtpItem.getChannelId();
        this.redis.set(key, (Object)sendRtpItem);
    }

    public SendRtpItem querySendRTPServer(String platformGbId, String channelId) {
        String key = "VMP_PLATFORM_SEND_RTP_INFO_" + platformGbId + "_" + channelId;
        return (SendRtpItem)this.redis.get(key);
    }

    public List<SendRtpItem> querySendRTPServer(String platformGbId) {
        String key = "VMP_PLATFORM_SEND_RTP_INFO_" + platformGbId + "_*";
        List queryResult = this.redis.scan(key);
        ArrayList<SendRtpItem> result = new ArrayList<SendRtpItem>();
        for (int i = 0; i < queryResult.size(); ++i) {
            String keyItem = (String)queryResult.get(i);
            result.add((SendRtpItem)this.redis.get(keyItem));
        }
        return result;
    }

    public void deleteSendRTPServer(String platformGbId, String channelId) {
        String key = "VMP_PLATFORM_SEND_RTP_INFO_" + platformGbId + "_" + channelId;
        this.redis.del(new String[]{key});
    }

    public boolean isChannelSendingRTP(String channelId) {
        String key = "VMP_PLATFORM_SEND_RTP_INFO_*_" + channelId;
        List RtpStreams = this.redis.scan(key);
        return RtpStreams.size() > 0;
    }

    public void clearCatchByDeviceId(String deviceId) {
        List playBackers;
        List playLeys = this.redis.scan(String.format("%S_*_%s_*", "VMP_PLAYER_", deviceId));
        if (playLeys.size() > 0) {
            for (Object key : playLeys) {
                this.redis.del(new String[]{key.toString()});
            }
        }
        if ((playBackers = this.redis.scan(String.format("%S_*_%s_*", "VMP_PLAYBACK_", deviceId))).size() > 0) {
            for (Object key : playBackers) {
                this.redis.del(new String[]{key.toString()});
            }
        }
    }

    public void outlineForAll() {
        List onlineDevices = this.redis.scan("VMP_keeplive_*");
        for (int i = 0; i < onlineDevices.size(); ++i) {
            String key = (String)onlineDevices.get(i);
            this.redis.del(new String[]{key});
        }
    }

    public List<String> getOnlineForAll() {
        ArrayList<String> result = new ArrayList<String>();
        List onlineDevices = this.redis.scan("VMP_keeplive_*");
        for (int i = 0; i < onlineDevices.size(); ++i) {
            String key = (String)onlineDevices.get(i);
            result.add((String)this.redis.get(key));
        }
        return result;
    }

    public void updateWVPInfo(JSONObject jsonObject) {
    }
}

