/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class JarFileUtils {
    private static Logger log = LoggerFactory.getLogger(JarFileUtils.class);
    private static Map<String, String> map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> readJarFile() {
        ZipFile jarFile = null;
        BufferedReader br = null;
        try {
            String jarFilePath = ClassUtils.getDefaultClassLoader().getResource("").getPath().replace("!/BOOT-INF/classes!/", "");
            if (jarFilePath.startsWith("file")) {
                jarFilePath = jarFilePath.substring(5);
            }
            log.debug("jarFilePath:" + jarFilePath);
            jarFile = new JarFile(jarFilePath);
            JarEntry entry = ((JarFile)jarFile).getJarEntry("META-INF/MANIFEST.MF");
            log.info("\u8bfb\u53d6\u7684\u5185\u5bb9:" + entry.toString());
            if (entry != null) {
                InputStream in = ((JarFile)jarFile).getInputStream(entry);
                StringBuilder sb = new StringBuilder();
                br = new BufferedReader(new InputStreamReader(in));
                String line = "";
                while ((line = br.readLine()) != null) {
                    if (line == null || !line.contains(":")) continue;
                    int index = line.indexOf(":");
                    map.put(line.substring(0, index).trim(), line.substring(index + 1, line.length()).trim());
                }
                Map map = JarFileUtils.map;
                return map;
            }
        }
        catch (IOException e) {
            log.debug("\u8bfb\u53d6MANIFEST.MF\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        finally {
            try {
                if (null != br) {
                    br.close();
                }
                if (null != jarFile) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

