/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.log;

import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.service.ILogService;
import com.genersoft.iot.vmp.storager.dao.dto.LogDto;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65e5\u5fd7\u7ba1\u7406"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/log"})
public class LogController {
    private static final Logger logger = LoggerFactory.getLogger(LogController.class);
    @Autowired
    private ILogService logService;
    @Autowired
    private UserSetup userSetup;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u62a5\u8b66")
    @GetMapping(value={"/all"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="query", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="count", value="\u6bcf\u9875\u67e5\u8be2\u6570\u91cf", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="type", value="\u7c7b\u578b", dataTypeClass=String.class), @ApiImplicitParam(name="startTime", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="endTime", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class)})
    public ResponseEntity<PageInfo<LogDto>> getAll(@RequestParam int page, @RequestParam int count, @RequestParam(required=false) String query, @RequestParam(required=false) String type, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime) {
        if (StringUtils.isEmpty((Object)query)) {
            query = null;
        }
        if (StringUtils.isEmpty((Object)startTime)) {
            startTime = null;
        }
        if (StringUtils.isEmpty((Object)endTime)) {
            endTime = null;
        }
        if (!this.userSetup.getLogInDatebase().booleanValue()) {
            logger.warn("\u81ea\u52a8\u8bb0\u5f55\u65e5\u5fd7\u529f\u80fd\u5df2\u5173\u95ed\uff0c\u67e5\u8be2\u7ed3\u679c\u53ef\u80fd\u4e0d\u5b8c\u6574\u3002");
        }
        try {
            if (startTime != null) {
                this.format.parse(startTime);
            }
            if (endTime != null) {
                this.format.parse(endTime);
            }
        }
        catch (ParseException e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        PageInfo allLog = this.logService.getAll(page, count, query, type, startTime, endTime);
        return new ResponseEntity((Object)allLog, HttpStatus.OK);
    }

    @ApiOperation(value="\u6e05\u7a7a\u65e5\u5fd7")
    @DeleteMapping(value={"/clear"})
    @ApiImplicitParams(value={})
    public ResponseEntity<WVPResult<String>> clear() {
        int count = this.logService.clear();
        WVPResult wvpResult = new WVPResult();
        wvpResult.setCode(0);
        wvpResult.setMsg("success");
        wvpResult.setData((Object)count);
        return new ResponseEntity((Object)wvpResult, HttpStatus.OK);
    }
}

